/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pos.controller;

import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextField;
import javafx.util.Callback;
import javafx.util.StringConverter;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import rs.tetrabyte.pos.controller.factory.CustomerTypeCellFactory;
import rs.tetrabyte.pos.controller.factory.CustomerTypeStringConverter;
import rs.tetrabyte.pos.model.entity.CustomerType;
import rs.tetrabyte.pos.model.view.CustomerView;
import rs.tetrabyte.pos.service.CustomerService;
import rs.tetrabyte.xcelerate.app.commands.UICommands;
import rs.tetrabyte.xcelerate.core.fxml.FXMLController;
import rs.tetrabyte.xcelerate.core.fxml.annotation.FXMLView;

@FXMLView(value="/fxml/AddCustomer.fxml")
public class AddCustomerController
extends FXMLController {
    @FXML
    private TextField uidField;
    @FXML
    private TextField nameField;
    @FXML
    private TextField addressField;
    @FXML
    private TextField postalCodeField;
    @FXML
    private TextField cityField;
    @FXML
    private TextField nationalIdField;
    @FXML
    private TextField tinField;
    @FXML
    private TextField upfunField;
    @FXML
    private TextField emailField;
    @FXML
    private ComboBox<CustomerType> typeComboBox;
    @Autowired
    private UICommands commands;
    private static final String EMAIL_REGEX = "^[A-Za-z0-9+_.-]+@[A-Za-z0-9.-]+$";
    @Autowired
    private CustomerService customerService;

    @PostConstruct
    private void load() {
        this.loadType();
        this.typeComboBox.setCellFactory((Callback)new CustomerTypeCellFactory());
        this.typeComboBox.setConverter((StringConverter)new CustomerTypeStringConverter());
    }

    private void loadType() {
        this.typeComboBox.getItems().setAll((Object[])CustomerType.values());
        this.typeComboBox.getSelectionModel().selectFirst();
    }

    @FXML
    private void saveCustomer() {
        try {
            String uid = this.uidField.getText();
            String name = this.nameField.getText();
            String address = this.addressField.getText();
            String postalCode = this.postalCodeField.getText();
            String city = this.cityField.getText();
            String nationalId = this.nationalIdField.getText();
            String tin = this.tinField.getText();
            String upfun = this.upfunField.getText();
            String email = this.emailField.getText();
            CustomerType type = (CustomerType)((Object)this.typeComboBox.getSelectionModel().getSelectedItem());
            if (uid.isEmpty() || name.isEmpty() || type == null) {
                this.commands.showAlert().error().withTitle("Gre\u0161ka", new Object[0]).withMessage("Popunite sva obavezna polja!", new Object[0]).execute();
                return;
            }
            if (!StringUtils.isNumeric((CharSequence)tin) || tin.length() != 9) {
                this.commands.showAlert().error().withTitle("Gre\u0161ka", new Object[0]).withMessage("PIB mora biti broj i imati ta\u010dno 9 cifara!", new Object[0]).execute();
                return;
            }
            if (!StringUtils.isNumeric((CharSequence)nationalId) || nationalId.length() != 13) {
                this.commands.showAlert().error().withTitle("Gre\u0161ka", new Object[0]).withMessage("Maticni broj mora biti broj i imati ta\u010dno 13 cifara!", new Object[0]).execute();
                return;
            }
            if (!StringUtils.isNumeric((CharSequence)upfun) || upfun.length() != 5) {
                this.commands.showAlert().error().withTitle("Gre\u0161ka", new Object[0]).withMessage("JBKJS mora biti broj i imati ta\u010dno 5 cifara!", new Object[0]).execute();
                return;
            }
            if (!email.matches("^[A-Za-z0-9+_.-]+@[A-Za-z0-9.-]+\\.[A-Za-z]{2,}$")) {
                this.commands.showAlert().error().withTitle("Gre\u0161ka", new Object[0]).withMessage("Unesite validnu email adresu!", new Object[0]).execute();
                return;
            }
            CustomerView newCustomer = new CustomerView();
            newCustomer.setUid(uid);
            newCustomer.setName(name);
            newCustomer.setAddress(address);
            newCustomer.setPostalCode(postalCode);
            newCustomer.setCity(city);
            newCustomer.setNationalId(nationalId);
            newCustomer.setTin(tin);
            newCustomer.setUpfun(upfun);
            newCustomer.setEmail(email);
            newCustomer.setType(type);
            this.customerService.addCustomer(newCustomer);
            this.clearCustomerFields();
        }
        catch (Exception ex) {
            this.commands.showAlert().error().withTitle("Gre\u0161ka", new Object[0]).withMessage("Do\u0161lo je do gre\u0161ke prilikom unosa podataka!", new Object[0]).execute();
        }
    }

    private void clearCustomerFields() {
        this.uidField.setText("");
        this.nameField.setText("");
        this.addressField.setText("");
        this.postalCodeField.setText("");
        this.cityField.setText("");
        this.nationalIdField.setText("");
        this.tinField.setText("");
        this.upfunField.setText("");
        this.emailField.setText("");
        this.typeComboBox.setValue(null);
    }

    @FXML
    private void onExit() {
        this.commands.removeView((Node)this.getRootNode()).execute();
    }
}

