/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pos.controller;

import java.util.Collection;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.util.Callback;
import javax.annotation.PostConstruct;
import org.controlsfx.control.GridView;
import org.springframework.beans.factory.annotation.Autowired;
import rs.tetrabyte.pos.controller.AddCategoryController;
import rs.tetrabyte.pos.controller.factory.CategoryGridCellWithMenuFactory;
import rs.tetrabyte.pos.model.view.CategoryView;
import rs.tetrabyte.pos.service.CategoryService;
import rs.tetrabyte.pos.service.ItemService;
import rs.tetrabyte.xcelerate.app.action.Action;
import rs.tetrabyte.xcelerate.app.commands.ShowAlert;
import rs.tetrabyte.xcelerate.app.commands.UICommands;
import rs.tetrabyte.xcelerate.core.fxml.FXMLController;
import rs.tetrabyte.xcelerate.core.fxml.annotation.FXMLView;
import rs.tetrabyte.xcelerate.core.fxml.annotation.Input;
import rs.tetrabyte.xcelerate.core.task.AbstractTask;
import rs.tetrabyte.xcelerate.core.task.TaskFactory;

@FXMLView(value="/fxml/CategoryView.fxml")
public class CategoryController
extends FXMLController {
    @FXML
    private GridView<CategoryView> gridView;
    @Autowired
    private CategoryService categoryService;
    @Autowired
    private ItemService itemService;
    @Autowired
    private UICommands commands;
    @Autowired
    private TaskFactory taskFactory;
    @Input(value="parentCategory")
    private CategoryView parentCategory;

    @PostConstruct
    private void init() {
        this.gridView.setCellFactory((Callback)new CategoryGridCellWithMenuFactory(categoryView -> this.loadView(CategoryController.class).output("parentCategory", categoryView).get(view -> this.commands.displayContent(view).execute()), categoryView -> this.loadView(AddCategoryController.class).output("selectedCategory", categoryView).output(this).get(view -> this.commands.displayContent(view).execute()), categoryView -> ((AbstractTask)((Object)((Object)this.taskFactory.createTask(() -> {
            ShowAlert alert = null;
            alert = !this.categoryService.getChildrenCategories((CategoryView)categoryView).isEmpty() ? this.commands.showAlert().error().withTitle("Brisanje kategorije", new Object[0]).withMessage("Brisanje kategorije nije mogu\u0107e jer izabrana kategorija ima svoje podkategorije", new Object[0]) : (!this.itemService.getItemsByCategory((CategoryView)categoryView).isEmpty() ? this.commands.showAlert().error().withTitle("Brisanje kategorije", new Object[0]).withMessage("Brisanje kategorije nije mogu\u0107e jer izabrana kategorija sadr\u017ei artikle", new Object[0]) : this.commands.showAlert().confirm().withTitle("Brisanje kategorije", new Object[0]).withMessage("Da li ste sigurni?", new Object[0]).onConfirmed((EventHandler<Event>)((EventHandler)e -> {
                this.categoryService.deleteCategoryById(categoryView.getId());
                this.refresh();
            })));
            return alert;
        }).whenDone(ShowAlert::execute)))).execute()));
        this.refresh();
    }

    public void refresh() {
        ((AbstractTask)((Object)this.taskFactory.createTask(() -> {
            if (this.parentCategory == null) {
                return this.categoryService.getRootCategories();
            }
            return this.categoryService.getChildrenCategories(this.parentCategory);
        }).whenDone(categories -> {
            this.gridView.getItems().clear();
            this.gridView.getItems().addAll((Collection)categories);
        }))).execute();
    }

    @Action(order=1, id="action-new", text="Dodaj kategoriju", accelerator="Ctrl+Insert")
    private void onCategoryAdd() {
        this.loadView(AddCategoryController.class).output("parentCategory", (Object)this.parentCategory).output(this).get(view -> this.commands.displayContent(view).execute());
    }
}

