/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pos.controller;

import java.util.List;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextField;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import rs.tetrabyte.pos.model.view.CategoryView;
import rs.tetrabyte.pos.service.CategoryService;
import rs.tetrabyte.xcelerate.app.commands.UICommands;
import rs.tetrabyte.xcelerate.core.fxml.FXMLController;
import rs.tetrabyte.xcelerate.core.fxml.annotation.FXMLView;

@FXMLView(value="/fxml/ChangeCategoryController.fxml")
public class ChangeCategoryController
extends FXMLController {
    @FXML
    private ComboBox<CategoryView> categoryComboBox;
    @FXML
    private TextField nameField;
    @FXML
    private TextField idField;
    @FXML
    private Button saveButton;
    @Autowired
    private UICommands commands;
    @Autowired
    CategoryService categoryService;

    @PostConstruct
    private void init() {
        this.loadCategories();
    }

    private void loadCategories() {
        List<CategoryView> categories = this.categoryService.getAllCategories();
        this.categoryComboBox.getItems().setAll(categories);
    }

    @FXML
    private void onSave() {
        CategoryView selectedCategory = (CategoryView)this.categoryComboBox.getValue();
        String newCategoryName = this.nameField.getText().trim();
        String categoryId = this.idField.getText().trim();
        if (newCategoryName.isEmpty()) {
            System.out.println("Naziv kategorije ne mo\u017ee biti prazan!");
            return;
        }
        if (categoryId.isEmpty()) {
            System.out.println("\u0160ifra kategorije ne mo\u017ee biti prazna!");
            return;
        }
        if (selectedCategory != null) {
            selectedCategory.setName(newCategoryName);
            this.categoryService.saveCategory(selectedCategory);
            System.out.println("Kategorija uspe\u0161no izmenjena!");
        } else {
            CategoryView newCategory = new CategoryView();
            newCategory.setName(newCategoryName);
            this.categoryService.saveCategory(newCategory);
            System.out.println("Nova kategorija kreirana!");
            if (selectedCategory != null) {
                this.categoryService.deleteCategoryById(selectedCategory.getId());
                System.out.println("Stara kategorija izbrisana: " + selectedCategory.getName());
            }
        }
        this.onExit();
    }

    @FXML
    private void onExit() {
        this.commands.removeView((Node)this.getRootNode()).execute();
    }
}

