/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pos.controller;

import java.math.BigDecimal;
import java.util.List;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextField;
import javafx.util.Callback;
import javafx.util.StringConverter;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import rs.tetrabyte.pos.builder.controls.FormattedTextField;
import rs.tetrabyte.pos.controller.converter.CategoryStringConverter;
import rs.tetrabyte.pos.controller.converter.ItemTypeStringConverter;
import rs.tetrabyte.pos.controller.factory.CategoryListCellFactory;
import rs.tetrabyte.pos.controller.factory.ItemTypeCellFactory;
import rs.tetrabyte.pos.model.entity.ItemType;
import rs.tetrabyte.pos.model.view.CategoryView;
import rs.tetrabyte.pos.model.view.ItemView;
import rs.tetrabyte.pos.service.CategoryService;
import rs.tetrabyte.pos.service.ItemService;
import rs.tetrabyte.xcelerate.app.commands.UICommands;
import rs.tetrabyte.xcelerate.core.fxml.FXMLController;
import rs.tetrabyte.xcelerate.core.fxml.annotation.FXMLView;
import rs.tetrabyte.xcelerate.core.fxml.annotation.Input;

@FXMLView(value="/fxml/AddItem.fxml")
public class ChangeItemController
extends FXMLController {
    @Autowired
    private UICommands commands;
    @FXML
    private TextField uidField;
    @FXML
    private TextField shortNameField;
    @FXML
    private TextField longNameField;
    @FXML
    private TextField eanField;
    @FXML
    private FormattedTextField<BigDecimal> priceField;
    @FXML
    private ComboBox<CategoryView> categoryComboBox;
    @FXML
    private ComboBox<ItemType> typeComboBox;
    @FXML
    private ComboBox<String> unitComboBox;
    @Autowired
    private ItemService itemService;
    @Autowired
    private CategoryService categoryService;
    @Input
    private ItemView currentItem;

    @PostConstruct
    public void setItem() {
        this.categoryComboBox.setCellFactory((Callback)new CategoryListCellFactory());
        this.categoryComboBox.setConverter((StringConverter)new CategoryStringConverter());
        this.loadCategories();
        this.loadUnits();
        this.typeComboBox.setCellFactory((Callback)new ItemTypeCellFactory());
        this.typeComboBox.setConverter((StringConverter)new ItemTypeStringConverter());
        this.typeComboBox.getItems().setAll((Object[])ItemType.values());
        this.populateFields();
    }

    private void loadCategories() {
        List<CategoryView> categories = this.categoryService.getAllCategories();
        this.categoryComboBox.getItems().setAll(categories);
    }

    private void loadUnits() {
        List<String> units = List.of("kom", "kg", "km", "g", "m", "l", "t", "m2", "m3", "min", "h", "d", "M", "god", "kWh", "s", "akt", "ha", "a", "cm2", "set", "komplet", "par", "kW");
        this.unitComboBox.getItems().setAll(units);
    }

    private void populateFields() {
        if (this.currentItem != null) {
            this.uidField.setText(this.currentItem.getUid());
            this.shortNameField.setText(this.currentItem.getShortName());
            this.longNameField.setText(this.currentItem.getLongName() != null ? this.currentItem.getLongName() : "");
            this.eanField.setText(this.currentItem.getEan());
            this.priceField.setValue(this.currentItem.getPrice());
            this.categoryComboBox.setValue((Object)this.currentItem.getCategory());
            this.typeComboBox.setValue((Object)this.currentItem.getItemType());
            this.unitComboBox.setValue((Object)this.currentItem.getUnit());
        } else {
            this.typeComboBox.setValue((Object)ItemType.PRODUCT);
            this.unitComboBox.setValue((Object)"kom");
        }
    }

    @FXML
    public void onExit() {
        this.commands.removeView((Node)this.getRootNode()).execute();
    }

    @FXML
    private void saveItem() {
        if (this.currentItem == null) {
            this.currentItem = new ItemView();
        }
        this.currentItem.setUid(this.uidField.getText());
        this.currentItem.setShortName(this.shortNameField.getText());
        this.currentItem.setLongName(this.longNameField.getText().isEmpty() ? null : this.longNameField.getText());
        this.currentItem.setEan(this.eanField.getText());
        this.currentItem.setUnit((String)this.unitComboBox.getValue());
        this.currentItem.setPrice(this.priceField.getValue());
        this.currentItem.setCategory((CategoryView)this.categoryComboBox.getValue());
        this.currentItem.setItemType((ItemType)((Object)this.typeComboBox.getValue()));
        this.itemService.addItem(this.currentItem);
        this.onExit();
    }
}

