/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pos.controller;

import java.util.Optional;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Pagination;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import rs.tetrabyte.pos.controller.EditCustomerViewController;
import rs.tetrabyte.pos.dao.Page;
import rs.tetrabyte.pos.model.view.CustomerView;
import rs.tetrabyte.pos.service.CustomerService;
import rs.tetrabyte.xcelerate.app.action.Action;
import rs.tetrabyte.xcelerate.app.commands.UICommands;
import rs.tetrabyte.xcelerate.app.control.LockablePaneWrapper;
import rs.tetrabyte.xcelerate.core.fxml.FXMLController;
import rs.tetrabyte.xcelerate.core.fxml.annotation.FXMLView;

@FXMLView(value="/fxml/CustomersView.fxml", wrappers={LockablePaneWrapper.class})
public class CustomersViewController
extends FXMLController {
    private static final int PAGE_SIZE = 100;
    @FXML
    private TableView<CustomerView> customerTable;
    @FXML
    private TextField txtFindName;
    @FXML
    private Pagination pagination;
    @FXML
    private TableColumn<CustomerView, String> nameColumn;
    @FXML
    private TableColumn<CustomerView, String> idColumn;
    @FXML
    private TableColumn<CustomerView, String> cityColumn;
    @FXML
    private TableColumn<CustomerView, String> nationalIdColumn;
    @FXML
    private TableColumn<CustomerView, String> tinColumn;
    @Autowired
    CustomerService customerService;
    @Autowired
    UICommands uiCommands;

    @PostConstruct
    public void initView() {
        this.idColumn.setCellValueFactory((Callback)new PropertyValueFactory("uid"));
        this.cityColumn.setCellValueFactory((Callback)new PropertyValueFactory("city"));
        this.nameColumn.setCellValueFactory((Callback)new PropertyValueFactory("name"));
        this.nationalIdColumn.setCellValueFactory((Callback)new PropertyValueFactory("nationalId"));
        this.tinColumn.setCellValueFactory((Callback)new PropertyValueFactory("tin"));
        this.txtFindName.setOnAction(e -> this.searchCustomers(this.txtFindName.getText()));
        this.loadAllCustomers();
    }

    public void loadAllCustomers() {
        this.doAsync(() -> this.customerService.getAllCustomers(100, 0)).whenDone(firstPage -> {
            this.pagination.setPageCount(firstPage.getPageCount());
            this.pagination.setPageFactory(pageIndex -> {
                if (pageIndex == 0) {
                    this.populateTable((Page<CustomerView>)firstPage);
                } else {
                    this.doAsync(() -> this.getAllCustomers((int)pageIndex)).whenDone(page -> this.populateTable((Page<CustomerView>)page));
                }
                return new VBox();
            });
        });
    }

    private void populateTable(Page<CustomerView> page) {
        this.customerTable.getItems().clear();
        this.customerTable.getItems().setAll(page.getData());
        if (this.customerTable.getItems().size() > 0) {
            this.customerTable.getSelectionModel().selectFirst();
        }
    }

    private void alertNoCustomersFound() {
        this.uiCommands.showAlert().error().withTitle("Gre\u0161ka", new Object[0]).withMessage("Nema dostupnih kupaca.", new Object[0]).execute();
    }

    private void searchCustomers(String searchText) {
        if (searchText.isEmpty()) {
            this.loadAllCustomers();
        } else {
            this.pagination.setPageFactory(null);
            this.doAsync(() -> this.customerService.searchCustomers(searchText, 100, 0)).whenDone(firstPage -> {
                if (firstPage.getTotalCount() == 0) {
                    this.customerTable.getItems().clear();
                    this.alertNoCustomersFound();
                    return;
                }
                this.pagination.setPageCount(firstPage.getPageCount());
                this.pagination.setPageFactory(pageIndex -> {
                    if (pageIndex == 0) {
                        this.populateTable((Page<CustomerView>)firstPage);
                    } else {
                        this.doAsync(() -> this.customerService.searchCustomers(searchText, 100, (int)pageIndex)).whenDone(page -> this.populateTable((Page<CustomerView>)page));
                    }
                    return new VBox();
                });
            });
        }
    }

    private Page<CustomerView> getAllCustomers(int pageIndex) {
        return this.customerService.getAllCustomers(100, pageIndex);
    }

    @Action(order=1, id="action-new", text="Novi kupac", accelerator="Ctrl+Insert", tooltip="Dodavanje novog kupca")
    private void newCustomer() {
        this.loadView(EditCustomerViewController.class).output(new CustomerView()).get(view -> this.uiCommands.displayContent(view).closable(false).execute());
    }

    @Action(order=2, id="action-edit", text="Izmena podataka", accelerator="F3", tooltip="Izmena podataka o kupcu")
    private void editCustomer() {
        CustomerView selected = (CustomerView)this.customerTable.getSelectionModel().getSelectedItem();
        if (selected == null) {
            return;
        }
        this.loadView(EditCustomerViewController.class).output(selected).get(view -> this.uiCommands.displayContent(view).closable(false).execute());
    }

    @Action(order=3, id="action-delete", text="Brisanje kupca", accelerator="Ctrl+Delete", tooltip="Brisanje podataka o kupcu")
    public void deleteCustomer(ActionEvent event) {
        Optional.ofNullable((CustomerView)this.customerTable.getSelectionModel().getSelectedItem()).ifPresent(selected -> this.uiCommands.showAlert().confirm().withTitle("Brisanje kupca", new Object[0]).withMessage("Da li ste sigurni da \u017eelite da obri\u0161ete kupca?", new Object[0]).onConfirmed((EventHandler<Event>)((EventHandler)e -> this.customerService.removeCustomerAsync(selected.getUid(), (ObservableList<CustomerView>)this.customerTable.getItems()))).execute());
    }
}

