/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pos.controller;

import java.util.List;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import rs.tetrabyte.pos.model.view.CategoryView;
import rs.tetrabyte.pos.service.CategoryService;
import rs.tetrabyte.xcelerate.app.commands.UICommands;
import rs.tetrabyte.xcelerate.core.fxml.FXMLController;
import rs.tetrabyte.xcelerate.core.fxml.annotation.FXMLView;

@FXMLView(value="/fxml/DeleteCategory.fxml")
public class DeleteCategoryController
extends FXMLController {
    @FXML
    private ComboBox<CategoryView> categoryComboBox;
    @FXML
    private Button deleteButton;
    @Autowired
    private UICommands commands;
    @Autowired
    CategoryService categoryService;

    @PostConstruct
    private void init() {
        this.loadCategories();
    }

    private void loadCategories() {
        List<CategoryView> categories = this.categoryService.getAllCategories();
        this.categoryComboBox.getItems().setAll(categories);
    }

    @FXML
    private void onDelete() {
        CategoryView selectedCategory = (CategoryView)this.categoryComboBox.getValue();
        if (selectedCategory == null) {
            System.out.println("Morate izabrati kategoriju za brisanje!");
            return;
        }
        this.categoryService.deleteCategoryById(selectedCategory.getId());
        System.out.println("Kategorija " + selectedCategory.getName() + " je uspe\u0161no obrisana!");
        this.loadCategories();
    }

    @FXML
    private void onExit() {
        this.commands.removeView((Node)this.getRootNode()).execute();
    }
}

