/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pos.controller;

import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextField;
import javafx.util.Callback;
import javafx.util.StringConverter;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import rs.tetrabyte.pos.controller.factory.CustomerTypeCellFactory;
import rs.tetrabyte.pos.controller.factory.CustomerTypeStringConverter;
import rs.tetrabyte.pos.model.entity.CustomerType;
import rs.tetrabyte.pos.model.view.CustomerView;
import rs.tetrabyte.pos.service.CustomerService;
import rs.tetrabyte.xcelerate.app.commands.UICommands;
import rs.tetrabyte.xcelerate.core.fxml.FXMLController;
import rs.tetrabyte.xcelerate.core.fxml.annotation.FXMLView;
import rs.tetrabyte.xcelerate.core.fxml.annotation.Input;

@FXMLView(value="/fxml/EditCustomerView.fxml")
public class EditCustomerViewController
extends FXMLController {
    @FXML
    private TextField uidField;
    @FXML
    private TextField nameField;
    @FXML
    private TextField addressField;
    @FXML
    private TextField postalCodeField;
    @FXML
    private TextField cityField;
    @FXML
    private TextField nationalIdField;
    @FXML
    private TextField tinField;
    @FXML
    private TextField upfunField;
    @FXML
    private TextField emailField;
    @FXML
    private ComboBox<CustomerType> typeComboBox;
    @Autowired
    private UICommands commands;
    @Autowired
    private CustomerService customerService;
    private CustomerView currentCustomer;

    @PostConstruct
    public void setCustomer(@Input CustomerView customerView) {
        this.typeComboBox.setCellFactory((Callback)new CustomerTypeCellFactory());
        this.typeComboBox.setConverter((StringConverter)new CustomerTypeStringConverter());
        this.typeComboBox.getItems().setAll((Object[])CustomerType.values());
        this.uidField.setText(customerView.getUid());
        this.nameField.setText(customerView.getName());
        this.addressField.setText(customerView.getAddress() != null ? customerView.getAddress() : "");
        this.postalCodeField.setText(customerView.getPostalCode() != null ? customerView.getPostalCode() : "");
        this.cityField.setText(customerView.getCity() != null ? customerView.getCity() : "");
        this.nationalIdField.setText(customerView.getNationalId() != null ? customerView.getNationalId() : "");
        this.tinField.setText(customerView.getTin() != null ? customerView.getTin() : "");
        this.upfunField.setText(customerView.getUpfun() != null ? customerView.getUpfun() : "");
        this.emailField.setText(customerView.getEmail() != null ? customerView.getEmail() : "");
        this.typeComboBox.setValue((Object)customerView.getType());
        this.currentCustomer = customerView;
    }

    @FXML
    private void saveCustomer() {
        this.currentCustomer.setUid(this.uidField.getText());
        this.currentCustomer.setName(this.nameField.getText());
        this.currentCustomer.setAddress(this.addressField.getText().isEmpty() ? null : this.addressField.getText());
        this.currentCustomer.setPostalCode(this.postalCodeField.getText().isEmpty() ? null : this.postalCodeField.getText());
        this.currentCustomer.setCity(this.cityField.getText().isEmpty() ? null : this.cityField.getText());
        this.currentCustomer.setNationalId(this.nationalIdField.getText().isEmpty() ? null : this.nationalIdField.getText());
        this.currentCustomer.setTin(this.tinField.getText().isEmpty() ? null : this.tinField.getText());
        this.currentCustomer.setUpfun(this.upfunField.getText().isEmpty() ? null : this.upfunField.getText());
        this.currentCustomer.setEmail(this.emailField.getText().isEmpty() ? null : this.emailField.getText());
        this.currentCustomer.setType((CustomerType)((Object)this.typeComboBox.getValue()));
        this.customerService.addCustomer(this.currentCustomer);
        this.onExit();
    }

    @FXML
    private void onExit() {
        this.commands.removeView((Node)this.getRootNode()).execute();
    }
}

