/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pos.controller;

import java.math.BigDecimal;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import rs.tetrabyte.pos.builder.controls.FormattedTextField;
import rs.tetrabyte.pos.controller.InvoiceViewController;
import rs.tetrabyte.pos.model.view.InvoiceItemView;
import rs.tetrabyte.pos.service.InvoiceItemService;
import rs.tetrabyte.pos.service.KeyboardService;
import rs.tetrabyte.xcelerate.app.action.Action;
import rs.tetrabyte.xcelerate.core.fxml.FXMLController;
import rs.tetrabyte.xcelerate.core.fxml.annotation.FXMLView;
import rs.tetrabyte.xcelerate.core.fxml.annotation.Input;

@FXMLView(value="/fxml/InvoiceItemEditView.fxml")
public class InvoiceItemEditViewController
extends FXMLController {
    @FXML
    private FormattedTextField<BigDecimal> txtPrice;
    @FXML
    private FormattedTextField<BigDecimal> txtQuantity;
    @FXML
    private TextField txtAddQty;
    @FXML
    private TextField txtSubQty;
    @FXML
    private Button btnSave;
    @FXML
    private Button btnAddQty;
    @FXML
    private Button btnMinusQty;
    @FXML
    private Button btnCancel;
    @Autowired
    private InvoiceItemService invoiceItemService;
    @Autowired
    private KeyboardService keyboardService;
    @Input
    private InvoiceItemView selectedItem;
    @Input
    private InvoiceViewController parent;

    @PostConstruct
    public void update() {
        if (this.selectedItem != null) {
            this.updateFields();
        } else {
            System.out.println("Nije inicijalizovan");
        }
    }

    @FXML
    private void onQuantityAction() {
        this.txtPrice.requestFocus();
    }

    @FXML
    private void onPriceAction() {
        this.save();
    }

    private void updateFields() {
        if (this.selectedItem != null) {
            this.txtPrice.setValue(this.selectedItem.getPrice());
            this.txtQuantity.setValue(this.selectedItem.getQuantity());
        } else {
            System.out.println("Nista");
        }
    }

    @FXML
    public void onInvoiceItemIncreaseQuantity(ActionEvent event) {
        BigDecimal q = new BigDecimal(this.txtQuantity.getText());
        if (this.txtAddQty != null && !this.txtAddQty.getText().isEmpty()) {
            q = q.add(new BigDecimal(this.txtAddQty.getText()));
            this.txtAddQty.clear();
        } else {
            q = q.add(BigDecimal.ONE);
            System.out.println("null");
        }
        this.txtQuantity.setText(q.toString());
    }

    @FXML
    public void onInvoiceItemDecreaseQuantity(ActionEvent event) {
        BigDecimal q = new BigDecimal(this.txtQuantity.getText());
        if (this.txtSubQty != null && !this.txtSubQty.getText().isEmpty()) {
            q = q.subtract(new BigDecimal(this.txtSubQty.getText()));
            this.txtSubQty.clear();
        } else {
            q = q.subtract(BigDecimal.ONE);
        }
        this.txtQuantity.setText(q.toString());
    }

    @FXML
    public void cancel() {
        this.parent.removeInvoiceItemEditView();
        this.keyboardService.deleteKeyboard();
    }

    @Action(order=1, id="action-new", text="Slika racuna", accelerator="F3")
    public void receiptImage() {
    }

    @Action(order=2, id="action-new", text="Storniranje racuna", accelerator="F4")
    public void declineReceipt() {
    }

    @FXML
    public void save() {
        this.selectedItem.setPrice(this.txtPrice.getValue());
        this.selectedItem.setQuantity(this.txtQuantity.getValue());
        this.invoiceItemService.updateInvoiceItem(this.selectedItem);
        this.parent.removeInvoiceItemEditView();
        this.keyboardService.deleteKeyboard();
    }
}

