/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pos.controller;

import java.math.BigDecimal;
import java.util.Optional;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.util.Callback;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import rs.tetrabyte.pos.controller.InvoiceItemEditViewController;
import rs.tetrabyte.pos.controller.ReceiptController;
import rs.tetrabyte.pos.controller.factory.InvoiceItemCellFactory;
import rs.tetrabyte.pos.factory.FormatterFactory;
import rs.tetrabyte.pos.model.view.InvoiceItemView;
import rs.tetrabyte.pos.model.view.ItemView;
import rs.tetrabyte.pos.service.InvoiceItemService;
import rs.tetrabyte.pos.service.ItemService;
import rs.tetrabyte.pos.util.DataValidator;
import rs.tetrabyte.xcelerate.app.commands.UICommands;
import rs.tetrabyte.xcelerate.app.control.LockablePane;
import rs.tetrabyte.xcelerate.app.control.LockablePaneWrapper;
import rs.tetrabyte.xcelerate.core.fxml.FXMLController;
import rs.tetrabyte.xcelerate.core.fxml.annotation.FXMLView;
import rs.tetrabyte.xcelerate.core.fxml.annotation.Output;
import rs.tetrabyte.xcelerate.core.task.UIAccessor;

@FXMLView(value="/fxml/InvoiceView.fxml", wrappers={LockablePaneWrapper.class})
public class InvoiceViewController
extends FXMLController {
    @FXML
    private Button btnInvoiceItemEdit;
    @FXML
    private Button btnDeleteItem;
    @FXML
    private Button btnInvoiceItemCancel;
    @FXML
    private Button btnKeyboard;
    @FXML
    private Button btnInvoiceCancel;
    @Output
    @FXML
    private ListView<InvoiceItemView> listInvoiceItems;
    @FXML
    private Label lblTotalValue;
    @FXML
    private Button btnPaymentCash;
    @FXML
    private Button btnPaymentCard;
    @FXML
    private Button btnIssueReceipt;
    @FXML
    private TextField txtSearch;
    private Node invoiceItemView;
    @Autowired
    private InvoiceItemService invoiceItemService;
    @Autowired
    private FormatterFactory formatterFactory;
    @Autowired
    private ItemService itemService;
    @Autowired
    private UICommands uiCommands;
    @Output
    private InvoiceItemView selectedItem;
    @Output
    private BigDecimal totalValue;

    @PostConstruct
    void loadInvoiceItems() {
        this.invoiceItemService.setUiAccessor((UIAccessor)this.getRootNode());
        this.listInvoiceItems.itemsProperty().bindBidirectional(this.invoiceItemService.invoiceItemsProperty());
        this.listInvoiceItems.setCellFactory((Callback)new InvoiceItemCellFactory(this.formatterFactory.createFormatter()));
        this.invoiceItemService.loadInvoiceItemsAsync();
        ((ObservableList)this.listInvoiceItems.itemsProperty().get()).addListener((ListChangeListener)new ListChangeListener<InvoiceItemView>(){

            public void onChanged(ListChangeListener.Change<? extends InvoiceItemView> c) {
                if (c.next()) {
                    if (c.getAddedSize() > 0) {
                        InvoiceViewController.this.listInvoiceItems.getSelectionModel().select(c.getFrom());
                        InvoiceViewController.this.listInvoiceItems.scrollTo(c.getFrom());
                    }
                    InvoiceViewController.this.totalValue = InvoiceViewController.this.listInvoiceItems.getItems().stream().map(item -> item.getTotal()).reduce(BigDecimal.ZERO, (a, b) -> a.add((BigDecimal)b));
                    InvoiceViewController.this.lblTotalValue.setText(InvoiceViewController.this.formatterFactory.createFormatter().amount(InvoiceViewController.this.totalValue));
                }
            }
        });
        this.listInvoiceItems.setOnMouseClicked(e -> {
            if (e.getClickCount() == 2) {
                this.onInvoiceItemEdit(null);
            }
        });
        this.txtSearch.setOnKeyReleased(e -> {
            if (e.getCode() == KeyCode.PLUS) {
                this.incInvoiceItemQuantity(BigDecimal.ONE);
            } else if (e.getCode() == KeyCode.MINUS) {
                this.incInvoiceItemQuantity(BigDecimal.ONE.multiply(new BigDecimal(-1)));
            }
        });
        this.txtSearch.setOnAction(e -> this.searchItem());
        this.txtSearch.requestFocus();
    }

    private void incInvoiceItemQuantity(BigDecimal one) {
    }

    public void searchItem() {
        Optional<Object> itemView = Optional.empty();
        itemView = DataValidator.isGTINValid(this.txtSearch.getText()) ? this.itemService.findItemByEan(this.txtSearch.getText()) : this.itemService.findItemByUid(this.txtSearch.getText());
        itemView.ifPresent(item -> {
            this.invoiceItemService.addItemToInvoiceAsync((ItemView)item);
            this.txtSearch.clear();
        });
    }

    public void removeInvoiceItemEditView() {
        this.getRootNode(LockablePane.class).removeNode(this.invoiceItemView);
    }

    @FXML
    public void onInvoiceItemEdit(ActionEvent event) {
        try {
            this.selectedItem = (InvoiceItemView)this.listInvoiceItems.getSelectionModel().getSelectedItem();
            if (this.selectedItem == null) {
                return;
            }
            this.loadView(InvoiceItemEditViewController.class).output("parent", (Object)this).getView(view -> {
                this.invoiceItemView = view;
                this.getRootNode(LockablePane.class).addNodeOnTop((Node)view);
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @FXML
    public void onReceipt(ActionEvent event) {
        if (this.listInvoiceItems.getItems().isEmpty()) {
            this.uiCommands.showAlert().error().withTitle("Greska!", new Object[0]).withMessage("Racun ne sme biti prazan", new Object[0]).execute();
            return;
        }
        this.loadView(ReceiptController.class).get(view -> this.uiCommands.displayContent(view).closable(false).execute());
    }

    public void refreshInvoiceItems() {
        this.listInvoiceItems.refresh();
    }

    @FXML
    public void onInvoiceItemCancel(ActionEvent event) {
        this.invoiceItemService.removeItemFromInvoiceAsync((InvoiceItemView)this.listInvoiceItems.getSelectionModel().getSelectedItem());
    }

    @FXML
    public void onInvoiceCancel(ActionEvent event) {
        this.invoiceItemService.removeAllItemsFromInvoiceAsync();
    }

    @FXML
    public void onPaymentCash(ActionEvent event) {
    }

    @FXML
    public void onPaymentCard(ActionEvent event) {
    }
}

