/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pos.controller;

import java.util.Optional;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Pagination;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import rs.tetrabyte.pos.controller.ChangeItemController;
import rs.tetrabyte.pos.dao.Page;
import rs.tetrabyte.pos.model.view.ItemView;
import rs.tetrabyte.pos.service.ItemService;
import rs.tetrabyte.xcelerate.app.action.Action;
import rs.tetrabyte.xcelerate.app.commands.UICommands;
import rs.tetrabyte.xcelerate.core.fxml.FXMLController;
import rs.tetrabyte.xcelerate.core.fxml.annotation.FXMLView;

@FXMLView(value="/fxml/Items.fxml")
public class ItemController
extends FXMLController {
    private static final int pageSize = 100;
    @FXML
    private TableView<ItemView> itemTable;
    @FXML
    private TextField txtFindName;
    @FXML
    private Pagination pagination;
    @FXML
    private TableColumn<ItemView, String> idColumn;
    @FXML
    private TableColumn<ItemView, String> eanColumn;
    @FXML
    private TableColumn<ItemView, String> nameColumn;
    @FXML
    private TableColumn<ItemView, String> unitColumn;
    @FXML
    private TableColumn<ItemView, Double> priceColumn;
    @FXML
    private TableColumn<ItemView, String> categoryColumn;
    @Autowired
    private ItemService itemService;
    @Autowired
    UICommands uiCommands;
    private ObservableList<ItemView> items;

    @PostConstruct
    public void initView() {
        this.idColumn.setCellValueFactory((Callback)new PropertyValueFactory("uid"));
        this.eanColumn.setCellValueFactory((Callback)new PropertyValueFactory("ean"));
        this.nameColumn.setCellValueFactory((Callback)new PropertyValueFactory("shortName"));
        this.unitColumn.setCellValueFactory((Callback)new PropertyValueFactory("unit"));
        this.priceColumn.setCellValueFactory((Callback)new PropertyValueFactory("price"));
        this.categoryColumn.setCellValueFactory(v -> ((ItemView)v.getValue()).getCategory().nameProperty());
        this.txtFindName.setOnAction(e -> this.searchItems(this.txtFindName.getText()));
        this.loadAllItems();
    }

    public void loadAllItems() {
        this.doAsync(() -> this.itemService.getAllItems(100, 0)).whenDone(firstPage -> {
            this.pagination.setPageCount(firstPage.getPageCount());
            this.pagination.setPageFactory(pageIndex -> {
                if (pageIndex == 0) {
                    this.populateTable((Page<ItemView>)firstPage);
                } else {
                    this.doAsync(() -> this.getItems((int)pageIndex)).whenDone(page -> this.populateTable((Page<ItemView>)page));
                }
                return new VBox();
            });
        });
    }

    private ObservableList<ItemView> getItemsForPage(int pageIndex) {
        Page<ItemView> page = this.itemService.getAllItems(100, pageIndex);
        return FXCollections.observableArrayList(page.getData());
    }

    private void populateTable(Page<ItemView> page) {
        this.itemTable.getItems().clear();
        this.itemTable.getItems().setAll(page.getData());
        if (this.itemTable.getItems().size() > 0) {
            this.itemTable.getSelectionModel().select(0);
            this.itemTable.scrollTo(0);
        }
    }

    private void alertNoItemsFound() {
        this.uiCommands.showAlert().error().withTitle("Gre\u0161ka", new Object[0]).withMessage("Nema dostupnih artikala.", new Object[0]).execute();
    }

    private Page<ItemView> getItems(int pageIndex) {
        return this.itemService.getAllItems(100, pageIndex);
    }

    private void searchItems(String searchText) {
        if (searchText.isEmpty()) {
            this.loadAllItems();
        } else if (searchText.startsWith("//")) {
            this.searchItemsByUid(searchText.substring(2));
        } else if (searchText.startsWith("**")) {
            this.searchItemsByEan(searchText.substring(2));
        } else {
            this.searchItemsFull(searchText);
        }
    }

    private void searchItemsFull(String searchText) {
        Page<ItemView> page = this.itemService.searchItems(searchText, 100, 0);
        ObservableList observableItems = FXCollections.observableArrayList(page.getData());
        this.itemTable.setItems(observableItems);
        int totalItems = page.getTotalCount();
        int pageCount = (int)Math.ceil((double)totalItems / 100.0);
        this.pagination.setPageCount(pageCount);
        this.pagination.setPageFactory(pageIndex -> {
            Page<ItemView> pageItems = this.itemService.searchItems(searchText, 100, (int)pageIndex);
            ObservableList currentPageItems = FXCollections.observableArrayList(pageItems.getData());
            this.itemTable.setItems(currentPageItems);
            return new VBox();
        });
        if (page.getTotalCount() == 0) {
            this.alertNoItemsFound();
        }
    }

    private void searchItemsByEan(String eanText) {
        Optional<ItemView> item = this.itemService.findItemByEan(eanText);
        ObservableList filteredItems = FXCollections.observableArrayList();
        item.ifPresent(arg_0 -> filteredItems.add(arg_0));
        this.itemTable.setItems(filteredItems);
        if (item.isEmpty()) {
            this.alertNoItemsFound();
        }
    }

    private void searchItemsByUid(String uidText) {
        Optional<ItemView> item = this.itemService.findItemByUid(uidText);
        ObservableList filteredItems = FXCollections.observableArrayList();
        item.ifPresent(arg_0 -> filteredItems.add(arg_0));
        this.itemTable.setItems(filteredItems);
        if (item.isEmpty()) {
            this.alertNoItemsFound();
        }
    }

    @Action(order=1, id="action-new", text="Dodaj Artikal", accelerator="Ctrl+Insert", tooltip="Dodavanje novog artikla")
    public void onArticles(ActionEvent event) {
        this.loadView(ChangeItemController.class).get(view -> this.uiCommands.displayContent(view).execute());
    }

    @Action(order=2, id="action-edit", text="Izmena artikla", accelerator="F3", tooltip="Izmena podataka o artiklu")
    public void onChange(ActionEvent event) {
        ItemView selectedItem = (ItemView)this.itemTable.getSelectionModel().getSelectedItem();
        if (selectedItem == null) {
            return;
        }
        this.loadView(ChangeItemController.class).output(selectedItem).get(view -> this.uiCommands.displayContent(view).execute());
    }

    @Action(order=3, id="action-delete", text="Brisanje artikla", accelerator="Ctrl+Delete", tooltip="Brisanje artikla")
    public void deleteItem(ActionEvent event) {
        ItemView selectedItem = (ItemView)this.itemTable.getSelectionModel().getSelectedItem();
        if (selectedItem == null) {
            this.uiCommands.showAlert().error().withTitle("Gre\u0161ka", new Object[0]).withMessage("Niste odabrali nijedan artikal za brisanje.", new Object[0]).execute();
            return;
        }
        this.uiCommands.showAlert().confirm().withTitle("Brisanje artikla", new Object[0]).withMessage("Da li ste sigurni da \u017eelite da obri\u0161ete ovaj artikal?", new Object[0]).onConfirmed((EventHandler<Event>)((EventHandler)e -> this.itemService.removeItemAsync(selectedItem.getUid(), (ObservableList<ItemView>)this.itemTable.getItems()))).execute();
    }
}

