/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pos.controller;

import java.util.function.Consumer;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import rs.tetrabyte.pos.controller.SearchViewController;
import rs.tetrabyte.pos.service.KeyboardService;
import rs.tetrabyte.xcelerate.core.fxml.FXMLController;
import rs.tetrabyte.xcelerate.core.fxml.annotation.FXMLView;
import rs.tetrabyte.xcelerate.core.fxml.annotation.Input;

@FXMLView(value="/fxml/Keyboard.fxml")
public class KeyboardController
extends FXMLController {
    @Autowired
    private KeyboardService keyboardService;
    @Input
    private SearchViewController parent;
    @Input
    private Boolean showCancelButton = Boolean.TRUE;
    private Consumer<KeyCode> consumer;
    @FXML
    private Button btnCancel;

    @PostConstruct
    private void postConstruct() {
        if (!this.showCancelButton.booleanValue()) {
            this.btnCancel.setVisible(false);
        }
    }

    @FXML
    public void keyboardCancel() {
        this.keyboardService.deleteKeyboard();
    }

    @FXML
    public void onButtonClick(ActionEvent event) {
        Button button;
        if (this.consumer != null && (button = (Button)event.getSource()).getId() != null && button.getId().startsWith("button")) {
            String buttonId = button.getId().replace("button", "");
            KeyCode keyCode = KeyCode.valueOf((String)buttonId);
            this.consumer.accept(keyCode);
        }
    }

    @FXML
    public void onDeleteCharacter(ActionEvent event) {
        int caretPosition;
        TextField currentTextField = this.keyboardService.getInputField();
        if (currentTextField != null && !currentTextField.getText().isEmpty() && (caretPosition = currentTextField.getCaretPosition()) > 0) {
            currentTextField.deleteText(caretPosition - 1, caretPosition);
        }
    }

    public void setConsumer(Consumer<KeyCode> consumer) {
        this.consumer = consumer;
    }
}

