/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pos.controller;

import java.util.Optional;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventType;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import org.springframework.beans.factory.annotation.Autowired;
import rs.tetrabyte.xcelerate.core.fxml.FXMLController;
import rs.tetrabyte.xcelerate.core.fxml.annotation.FXMLView;

@FXMLView(value="/fxml/NumpadView.fxml")
public class NumpadViewController
extends FXMLController {
    @FXML
    private Button buttonDIGIT1;
    @FXML
    private Button buttonDIGIT2;
    @FXML
    private Button buttonDIGIT3;
    @FXML
    private Button buttonDIGIT4;
    @FXML
    private Button buttonDIGIT5;
    @FXML
    private Button buttonDIGIT6;
    @FXML
    private Button buttonDIGIT7;
    @FXML
    private Button buttonDIGIT8;
    @FXML
    private Button buttonDIGIT9;
    @FXML
    private Button buttonDIGIT0;
    @FXML
    private Button buttonDECIMAL;
    @Autowired
    private Scene scene;

    private Optional<TextField> getFocusedTextField() {
        Node focusOwner = this.scene.getFocusOwner();
        if (focusOwner != null && focusOwner instanceof TextField) {
            return Optional.of((TextField)focusOwner);
        }
        return Optional.empty();
    }

    private KeyEvent createKeyEvent(KeyCode keyCode, EventType<KeyEvent> eventType) {
        return new KeyEvent(eventType, keyCode.getChar(), "", keyCode, false, false, false, false);
    }

    private void fireKeyEvent(KeyCode keyCode) {
        this.getFocusedTextField().ifPresent(textFiled -> {
            textFiled.fireEvent((Event)this.createKeyEvent(keyCode, (EventType<KeyEvent>)KeyEvent.KEY_PRESSED));
            textFiled.fireEvent((Event)this.createKeyEvent(keyCode, (EventType<KeyEvent>)KeyEvent.KEY_RELEASED));
            textFiled.fireEvent((Event)this.createKeyEvent(keyCode, (EventType<KeyEvent>)KeyEvent.KEY_TYPED));
        });
    }

    @FXML
    public void onBackspace(ActionEvent event) {
        this.getFocusedTextField().ifPresent(textField -> {
            int caretPosition = textField.getCaretPosition();
            if (caretPosition > 0) {
                textField.deleteText(caretPosition - 1, caretPosition);
            }
        });
    }

    @FXML
    public void onCancel(ActionEvent event) {
        this.getFocusedTextField().ifPresent(textField -> {
            textField.setText("0");
            textField.selectPositionCaret(0);
        });
    }

    @FXML
    public void onButtonClick(ActionEvent event) {
        Button button = (Button)event.getSource();
        if (button.getId() != null && button.getId().startsWith("button")) {
            String buttonId = button.getId().replace("button", "");
            KeyCode keyCode = KeyCode.valueOf((String)buttonId);
            this.fireKeyEvent(keyCode);
        }
    }
}

