/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pos.controller;

import java.time.LocalDate;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TextArea;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import rs.tetrabyte.pos.service.SDCService;
import rs.tetrabyte.xcelerate.app.commands.UICommands;
import rs.tetrabyte.xcelerate.app.control.LockablePaneWrapper;
import rs.tetrabyte.xcelerate.core.fxml.FXMLController;
import rs.tetrabyte.xcelerate.core.fxml.annotation.FXMLView;

@FXMLView(value="/fxml/PeriodicReportView.fxml", wrappers={LockablePaneWrapper.class})
public class PeriodicReportViewController
extends FXMLController {
    @FXML
    private DatePicker dpStart;
    @FXML
    private DatePicker dpEnd;
    @FXML
    private TextArea textArea;
    @Autowired
    private SDCService sdcService;
    @Autowired
    private UICommands uiCommands;

    @PostConstruct
    private void init() {
        this.dpStart.valueProperty().addListener((o, ov, nv) -> this.showReport());
        this.dpEnd.valueProperty().addListener((o, ov, nv) -> this.showReport());
        this.showReport();
    }

    private void showReport() {
        this.doAsync(() -> this.sdcService.getPeriodicReport((LocalDate)this.dpStart.getValue(), (LocalDate)this.dpEnd.getValue())).whenDone(report -> this.textArea.setText(report.getJournal()));
    }

    private void printReport() {
        this.doAsync(() -> this.sdcService.printPeriodicReport((LocalDate)this.dpStart.getValue(), (LocalDate)this.dpEnd.getValue())).whenDone(report -> this.textArea.setText(report.getJournal()));
    }

    @FXML
    public void print(ActionEvent event) {
        this.uiCommands.showAlert().confirm().withTitle("\u0160tampanje izve\u0161taja", new Object[0]).withMessage("\u0160tampate izve\u0161taj?", new Object[0]).onConfirmed((EventHandler<Event>)((EventHandler)e -> {
            this.printReport();
            this.close(event);
        })).execute();
    }

    @FXML
    public void close(ActionEvent event) {
        this.uiCommands.removeView((Node)this.getRootNode()).execute();
    }
}

