/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pos.controller;

import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.TextField;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import rs.tetrabyte.pos.model.view.CustomerView;
import rs.tetrabyte.pos.util.DataValidator;
import rs.tetrabyte.pos.util.StringUtil;
import rs.tetrabyte.xcelerate.app.commands.UICommands;
import rs.tetrabyte.xcelerate.core.fxml.FXMLController;
import rs.tetrabyte.xcelerate.core.fxml.annotation.FXMLView;
import rs.tetrabyte.xcelerate.core.fxml.annotation.Input;

@FXMLView(value="/fxml/ReceiptCompanySearchView.fxml")
public class ReceiptCompanySearchViewController
extends FXMLController {
    private static final String BASE_URI = "https://company.apis.tetrabyte.rs/public/v1/companies/search/byNatIdAndTaxId";
    @FXML
    private TextField search;
    @FXML
    private TextField name;
    @FXML
    private TextField address;
    @FXML
    private TextField city;
    @FXML
    private TextField tin;
    @FXML
    private TextField nat;
    @FXML
    private TextField budgetId;
    @Input
    private ObjectProperty<CustomerView> customer;
    @Autowired
    private UICommands uiCommands;
    @Autowired
    private GsonBuilder gsonBuilder;

    public void requestFocus() {
        this.search.requestFocus();
    }

    @FXML
    public void clear() {
        this.name.clear();
        this.address.clear();
        this.city.clear();
        this.tin.clear();
        this.nat.clear();
        this.budgetId.clear();
        this.customer.set(null);
    }

    @FXML
    public void search(ActionEvent event) {
        Object url = BASE_URI;
        String searchText = this.search.getText().trim();
        if (!DataValidator.isPIBValid(searchText)) {
            this.uiCommands.showAlert().error().withTitle("Neispravni podaci", new Object[0]).withMessage("Polje za pretragu ne sadr\u017ei validan PIB", new Object[0]).execute();
            this.clear();
            this.customer.set(null);
            return;
        }
        url = (String)url + "?taxId=" + searchText;
        CloseableHttpClient client = HttpClientBuilder.create().setDefaultRequestConfig(RequestConfig.custom().setConnectionRequestTimeout(60000).setConnectTimeout(10000).setSocketTimeout(10000).build()).build();
        HttpGet get = new HttpGet((String)url);
        this.doAsync(() -> client.execute((HttpUriRequest)get).getEntity()).onFailed(e -> {
            e.printStackTrace();
            this.uiCommands.showAlert().error().withTitle("Gre\u0161ka u komunikaciji", new Object[0]).withMessage(e.getMessage(), new Object[0]).execute();
        }).whenDone(entity -> {
            try {
                List response = (List)this.deserialize((HttpEntity)entity);
                CompanyResponse companyResponse = null;
                Iterator iterator = response.iterator();
                while (iterator.hasNext() && companyResponse == null) {
                    CompanyResponse temp = (CompanyResponse)iterator.next();
                    if (!temp.getTaxId().equals(searchText)) continue;
                    companyResponse = temp;
                }
                if (companyResponse != null) {
                    this.name.setText(!StringUtil.isBlank(companyResponse.getShortName()) ? companyResponse.getShortName() : companyResponse.getName());
                    this.address.setText(companyResponse.getAddress());
                    this.city.setText(companyResponse.getCity());
                    this.tin.setText(companyResponse.getTaxId());
                    this.nat.setText(companyResponse.getNatId());
                    this.budgetId.setText(companyResponse.getBudgetUserId());
                    CustomerView customer = new CustomerView();
                    customer.setName(this.name.getText());
                    customer.setAddress(this.address.getText());
                    customer.setCity(this.city.getText());
                    customer.setTin(this.tin.getText());
                    customer.setNationalId(this.nat.getText());
                    customer.setUpfun(this.budgetId.getText());
                    this.customer.set((Object)customer);
                } else {
                    this.customer.set(null);
                    this.uiCommands.showAlert().error().withTitle("Nema pogodaka", new Object[0]).withMessage("U registru NBS nije prona\u0111ena ni jedna firma sa tra\u017eenim PIB-om", new Object[0]).execute();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                this.uiCommands.showAlert().error().withTitle("Gre\u0161ka", new Object[0]).withMessage(e.getMessage(), new Object[0]).execute();
            }
        });
    }

    private <T> T deserialize(HttpEntity entity) throws UnsupportedOperationException, IOException {
        try (InputStream is = entity.getContent();){
            Object object;
            try (InputStreamReader reader = new InputStreamReader(is);){
                Type listType = new TypeToken<ArrayList<CompanyResponse>>(){}.getType();
                object = this.gsonBuilder.create().fromJson((Reader)reader, listType);
            }
            return (T)object;
        }
    }

    private static class CompanyResponse {
        private String natId;
        private String taxId;
        private String name;
        private String shortName;
        private String address;
        private String city;
        private String municipality;
        private String region;
        private String postalCode;
        private String budgetUserId;

        private CompanyResponse() {
        }

        public String getNatId() {
            return this.natId;
        }

        public String getTaxId() {
            return this.taxId;
        }

        public String getName() {
            return this.name;
        }

        public String getShortName() {
            return this.shortName;
        }

        public String getAddress() {
            return this.address;
        }

        public String getCity() {
            return this.city;
        }

        public String getMunicipality() {
            return this.municipality;
        }

        public String getRegion() {
            return this.region;
        }

        public String getPostalCode() {
            return this.postalCode;
        }

        public String getBudgetUserId() {
            return this.budgetUserId;
        }
    }
}

