/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pos.controller;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Accordion;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.ListView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import rs.tetrabyte.pos.builder.controls.DateTimePicker;
import rs.tetrabyte.pos.builder.controls.FormattedTextField;
import rs.tetrabyte.pos.controller.NumpadViewController;
import rs.tetrabyte.pos.controller.ReceiptCompanySearchViewController;
import rs.tetrabyte.pos.controller.wrapper.PopupViewWrapper;
import rs.tetrabyte.pos.model.entity.PaymentType;
import rs.tetrabyte.pos.model.view.CustomerView;
import rs.tetrabyte.pos.model.view.InvoiceItemView;
import rs.tetrabyte.pos.model.view.InvoiceView;
import rs.tetrabyte.pos.sdc.BuyerCostCenter;
import rs.tetrabyte.pos.sdc.BuyerIdentification;
import rs.tetrabyte.pos.sdc.InvoiceTransaction;
import rs.tetrabyte.pos.sdc.SDCException;
import rs.tetrabyte.pos.service.InvoiceItemService;
import rs.tetrabyte.pos.service.InvoiceService;
import rs.tetrabyte.pos.service.SDCService;
import rs.tetrabyte.xcelerate.app.commands.UICommands;
import rs.tetrabyte.xcelerate.core.fxml.FXMLController;
import rs.tetrabyte.xcelerate.core.fxml.annotation.FXMLView;
import rs.tetrabyte.xcelerate.core.fxml.annotation.Input;
import rs.tetrabyte.xcelerate.core.fxml.annotation.Output;

@FXMLView(value="/fxml/ReceiptView.fxml", wrappers={PopupViewWrapper.class})
public class ReceiptController
extends FXMLController {
    @FXML
    private Accordion accordion;
    @FXML
    private TitledPane paymentPane;
    @FXML
    private TitledPane receiptPane;
    @FXML
    private TitledPane customerPane;
    @FXML
    private TitledPane messagePane;
    @FXML
    private CheckBox btnSum;
    @FXML
    private FormattedTextField<BigDecimal> invoiceAmount;
    @FXML
    private DateTimePicker referentDateTime;
    @FXML
    private TextField referentNumber;
    @FXML
    private FormattedTextField<BigDecimal> discountPercent;
    @FXML
    private FormattedTextField<BigDecimal> paymentOther;
    @FXML
    private FormattedTextField<BigDecimal> paymentInstant;
    @FXML
    private FormattedTextField<BigDecimal> paymentVoucher;
    @FXML
    private FormattedTextField<BigDecimal> paymentWireTransfer;
    @FXML
    private FormattedTextField<BigDecimal> paymentCard;
    @FXML
    private FormattedTextField<BigDecimal> paymentCheck;
    @FXML
    private FormattedTextField<BigDecimal> paymentCash;
    @FXML
    private FormattedTextField<BigDecimal> receivedTotal;
    @FXML
    private FormattedTextField<BigDecimal> refund;
    @FXML
    private TextField advanceAmount;
    @FXML
    private TextField advanceTaxAmount;
    @FXML
    private ComboBox<InvoiceTransaction> receiptType;
    @FXML
    private DateTimePicker dateAndTimeOfIssue;
    @FXML
    private ComboBox<String> choiceID;
    @FXML
    private TextField buyerId;
    @FXML
    private ComboBox<BuyerCostCenter> buyerCostCenterType;
    @FXML
    private ComboBox<BuyerIdentification> buyerType;
    @FXML
    private TextField buyerCostCenterId;
    @FXML
    private DatePicker dueDate;
    @FXML
    private DatePicker customDate;
    @FXML
    private BorderPane keyboardPane;
    @FXML
    private Button btnSave;
    @FXML
    private TextArea messageArea;
    @Autowired
    private SDCService sdcService;
    @Autowired
    private InvoiceService invoiceService;
    @Autowired
    private UICommands uiCommands;
    @Autowired
    private InvoiceItemService invoiceItemService;
    @Input
    private BigDecimal totalValue;
    @Input
    private ListView<InvoiceItemView> listInvoiceItems;
    @Input
    private boolean skipEsdc;
    @Output
    private ObjectProperty<CustomerView> customer = new SimpleObjectProperty();
    private List<FormattedTextField<BigDecimal>> paymentList;

    @PostConstruct
    public void postConstruct() {
        this.initPanes();
        this.initKeyboard();
        this.initReceiptType();
        this.initBuyerType();
        this.initBuyerCostCenterType();
        this.initPaymentList();
        this.initDefaultFieldValues();
        this.setupKeyListeners();
        this.setupCustomerListener();
        this.paymentCash.requestFocus();
    }

    private void initPanes() {
        this.accordion.setExpandedPane(this.paymentPane);
        this.loadView(ReceiptCompanySearchViewController.class).get(value -> {
            ReceiptCompanySearchViewController controller = (ReceiptCompanySearchViewController)value.getController();
            this.customerPane.setContent(value.getView());
            this.customerPane.setOnMouseClicked(e -> controller.requestFocus());
        });
        this.messagePane.setOnMouseClicked(e -> this.messagePane.getContent().requestFocus());
        this.paymentPane.setOnMouseClicked(e -> this.paymentCash.requestFocus());
    }

    private void initPaymentList() {
        this.paymentList = Arrays.asList(this.paymentCard, this.paymentCheck, this.paymentInstant, this.paymentVoucher, this.paymentWireTransfer, this.paymentOther);
        ChangeListener listener = (o, ov, nv) -> this.sumPayments();
        this.paymentList.forEach(field -> {
            field.valueProperty().addListener(listener);
            field.setOnAction(e -> this.paymentCash.requestFocus());
        });
        this.paymentCash.valueProperty().addListener((o, ov, nv) -> this.handleCashPaymentChanged());
        this.paymentCash.setOnAction(e -> this.btnSave.requestFocus());
    }

    private void handleCashPaymentChanged() {
        BigDecimal totalPayments = this.paymentCash.getValue().add(this.paymentList.stream().map(p -> (BigDecimal)p.getValue()).reduce(BigDecimal.ZERO, (a, b) -> a.add((BigDecimal)b)));
        this.receivedTotal.setValue(totalPayments);
        this.refund.setValue(totalPayments.subtract(this.invoiceAmount.getValue()));
    }

    private void sumPayments() {
        BigDecimal totalMinusCash = this.paymentList.stream().map(p -> (BigDecimal)p.getValue()).reduce(BigDecimal.ZERO, (a, b) -> a.add((BigDecimal)b));
        BigDecimal cash = this.invoiceAmount.getValue().subtract(totalMinusCash);
        if (cash.compareTo(BigDecimal.ZERO) >= 0) {
            this.paymentCash.setValue(cash);
        } else {
            this.paymentCash.setValue(BigDecimal.ZERO);
        }
    }

    private void initKeyboard() {
        this.loadView(NumpadViewController.class).output("showCancelButton", (Object)Boolean.FALSE).getView(view -> this.keyboardPane.setCenter(view));
    }

    private void initDefaultFieldValues() {
        this.invoiceAmount.setValue(this.totalValue);
        this.paymentCash.setValue(this.totalValue);
        this.receivedTotal.setValue(this.totalValue);
        if (this.skipEsdc) {
            this.customDate.setValue((Object)LocalDate.now());
        }
    }

    public void initReceiptType() {
        this.receiptType.getItems().addAll((Object[])InvoiceTransaction.getAll());
        this.receiptType.valueProperty().addListener((o, ov, nv) -> {
            boolean referenceDisabled = !nv.isReferenceRequired() && !nv.isReferenceOptional();
            this.referentNumber.setDisable(referenceDisabled);
            this.referentDateTime.setDisable(referenceDisabled);
            if (referenceDisabled) {
                this.referentNumber.setText("");
                this.referentDateTime.setValue(null);
            }
            this.dateAndTimeOfIssue.setDisable(nv != InvoiceTransaction.ADVANCE_SALE);
        });
        this.receiptType.setValue((Object)InvoiceTransaction.NORMAL_SALE);
    }

    public void initBuyerCostCenterType() {
        this.buyerCostCenterType.getItems().addAll((Object[])BuyerCostCenter.getAll());
        this.buyerCostCenterType.valueProperty().addListener((o, ov, nv) -> {
            boolean buyerCostCenterIdDisabled = nv == BuyerCostCenter.BEZ_IDENTIFIKACIJE;
            this.buyerCostCenterType.setDisable(buyerCostCenterIdDisabled);
            if (buyerCostCenterIdDisabled) {
                this.buyerCostCenterId.setText("");
            }
        });
        this.buyerCostCenterType.setValue((Object)BuyerCostCenter.BEZ_IDENTIFIKACIJE);
    }

    public void initBuyerType() {
        this.buyerType.getItems().addAll((Object[])BuyerIdentification.getAll());
        this.buyerType.valueProperty().addListener((o, ov, nv) -> {
            boolean buyerCostCenterTypeDisabled = nv == BuyerIdentification.BEZ_IDENTIFIKACIJE;
            this.buyerCostCenterType.setDisable(buyerCostCenterTypeDisabled);
            if (buyerCostCenterTypeDisabled) {
                this.buyerCostCenterType.getSelectionModel().select((Object)BuyerCostCenter.BEZ_IDENTIFIKACIJE);
            }
        });
        this.buyerType.setValue((Object)BuyerIdentification.BEZ_IDENTIFIKACIJE);
    }

    private void setupKeyListeners() {
        this.setArrowKeysListener(this.paymentCash, this.paymentCard);
        this.setArrowKeysListener(this.paymentCard, this.paymentCheck);
        this.setArrowKeysListener(this.paymentCheck, this.paymentWireTransfer);
    }

    private void setupCustomerListener() {
        this.customer.addListener((o, ov, nv) -> {
            if (nv == null) {
                this.buyerType.setValue((Object)BuyerIdentification.BEZ_IDENTIFIKACIJE);
                this.buyerId.clear();
                this.messageArea.clear();
            } else if (nv.getUpfun() == null || nv.getUpfun().isBlank()) {
                this.buyerType.setValue((Object)BuyerIdentification.PIB_KUPCA);
                this.buyerId.setText(nv.getTin());
            } else {
                this.buyerType.setValue((Object)BuyerIdentification.PIB_JBKJS);
                this.buyerId.setText(nv.getTin() + ":" + nv.getUpfun());
            }
        });
    }

    private void setArrowKeysListener(FormattedTextField<BigDecimal> current, FormattedTextField<BigDecimal> next) {
        current.addEventFilter(KeyEvent.KEY_RELEASED, e -> {
            if (e.getCode() == KeyCode.UP) {
                BigDecimal value = (BigDecimal)current.getValue();
                if (value.compareTo(this.invoiceAmount.getValue()) != 0) {
                    next.requestFocus();
                } else {
                    current.setValue(BigDecimal.ZERO);
                    next.setValue(value);
                    next.requestFocus();
                }
            }
        });
        this.setPreviousField(next, current);
    }

    private boolean validate() {
        ArrayList<String> errors = new ArrayList<String>();
        if (this.refund.getValue().compareTo(BigDecimal.ZERO) < 0) {
            errors.add("Nelogi\u010dna suma uplata");
            this.paymentCash.requestFocus();
        }
        if (!((BuyerIdentification)this.buyerType.getValue()).isValid(this.buyerId.getText())) {
            errors.add("Identifikator kupca ne sadr\u017ei ispravne podatke");
        }
        if (!((BuyerCostCenter)this.buyerCostCenterType.getValue()).isValid(this.buyerCostCenterId.getText())) {
            errors.add("Identifikator opcionog polja ne sadr\u017ei ispravne podatke");
        }
        if (((InvoiceTransaction)this.receiptType.getValue()).isReferenceRequired() && this.referentNumber.getText().isBlank()) {
            errors.add("Referentni broj nije unet");
        }
        if (!this.referentNumber.getText().isBlank()) {
            if (!this.referentNumber.getText().matches("^(\\w{8}-\\w{8}-\\d*)?$")) {
                errors.add("Referentni broj ne sadr\u017ei ispravne podatke");
            }
            if (this.referentDateTime.getValue() == null) {
                errors.add("Referentno vreme nije uneto");
            }
        }
        if (((InvoiceTransaction)this.receiptType.getValue()).isAdvance()) {
            if (this.dateAndTimeOfIssue.getValue() == null) {
                errors.add("Vreme avansne uplate mora biti popunjeno");
            } else {
                this.dateAndTimeOfIssue.setValue(null);
            }
        }
        if (!errors.isEmpty()) {
            this.uiCommands.showAlert().error().withTitle("Podaci nisu validni", new Object[0]).withMessage("- " + String.join((CharSequence)"\r\n- ", errors), new Object[0]).execute();
            return false;
        }
        return true;
    }

    private void createInvoice() {
        InvoiceView invoice = new InvoiceView();
        invoice.setId(UUID.randomUUID());
        invoice.setType((InvoiceTransaction)this.receiptType.getValue());
        invoice.setCashier("Ime Kasira");
        invoice.setBuyerId(((BuyerIdentification)this.buyerType.getValue()).value(this.buyerId.getText()));
        invoice.setBuyerCostCenterId(((BuyerCostCenter)this.buyerCostCenterType.getValue()).value(this.buyerCostCenterId.getText()));
        if (!this.referentNumber.getText().isBlank()) {
            invoice.setReferentDocumentNumber(this.referentNumber.getText());
            invoice.setReferentDocumentDT((LocalDateTime)this.referentDateTime.dateTimeValueProperty().get());
        }
        if (this.dateAndTimeOfIssue.getValue() != null) {
            invoice.setDateAndTimeOfIssue((LocalDateTime)this.dateAndTimeOfIssue.dateTimeValueProperty().get());
        }
        invoice.addNonZeroPayment(PaymentType.Cash, this.paymentCash.getValue());
        invoice.addNonZeroPayment(PaymentType.Other, this.paymentOther.getValue());
        invoice.addNonZeroPayment(PaymentType.Card, this.paymentCard.getValue());
        invoice.addNonZeroPayment(PaymentType.Check, this.paymentCheck.getValue());
        invoice.addNonZeroPayment(PaymentType.WireTransfer, this.paymentWireTransfer.getValue());
        invoice.addNonZeroPayment(PaymentType.MobileMoney, this.paymentInstant.getValue());
        invoice.addNonZeroPayment(PaymentType.Voucher, this.paymentVoucher.getValue());
        invoice.setItems((List<InvoiceItemView>)this.listInvoiceItems.getItems());
        invoice.setCustomer((CustomerView)this.customer.getValue());
        invoice.setMessage(this.messageArea.getText());
        this.doAsync(() -> {
            this.invoiceService.addInvoice(invoice);
            return null;
        }).onFailed(e -> {
            e.printStackTrace();
            this.uiCommands.showAlert().error().withTitle("Greska prilikom potpisivanja racuna", new Object[0]).withMessage(e.getMessage(), new Object[0]).execute();
        }).whenDone(a -> {
            this.cancel();
            this.invoiceItemService.removeAllItemsFromInvoiceAsync();
        });
    }

    @FXML
    public void saveReceipt() throws SDCException {
        if (!this.validate()) {
            return;
        }
        this.sdcService.verifyPin(() -> this.createInvoice());
    }

    private void setPreviousField(FormattedTextField<BigDecimal> current, FormattedTextField<BigDecimal> previous) {
        current.addEventFilter(KeyEvent.KEY_RELEASED, e -> {
            if (e.getCode() == KeyCode.DOWN) {
                BigDecimal value = (BigDecimal)current.getValue();
                if (value.compareTo(this.invoiceAmount.getValue()) != 0) {
                    previous.requestFocus();
                } else {
                    current.setValue(BigDecimal.ZERO);
                    previous.setValue(value);
                    previous.requestFocus();
                }
            }
        });
    }

    @FXML
    public void toggleEdit() {
        boolean isSelected = this.btnSum.isSelected();
        this.advanceAmount.setEditable(isSelected);
        this.advanceTaxAmount.setEditable(isSelected);
    }

    @FXML
    public void cancel() {
        this.uiCommands.removeView((Node)this.getRootNode()).execute();
    }
}

