/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pos.controller.factory;

import java.util.Optional;
import java.util.function.Consumer;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.util.Callback;
import org.controlsfx.control.GridCell;
import org.controlsfx.control.GridView;
import rs.tetrabyte.pos.model.view.CategoryView;
import rs.tetrabyte.xcelerate.app.factory.GlyphFactory;
import rs.tetrabyte.xcelerate.app.util.StringUtils;

public class CategoryGridCellWithMenuFactory
implements Callback<GridView<CategoryView>, GridCell<CategoryView>> {
    private final Consumer<CategoryView> onEdit;
    private final Consumer<CategoryView> onDelete;
    private Consumer<CategoryView> onAction;

    public CategoryGridCellWithMenuFactory(Consumer<CategoryView> onAction, Consumer<CategoryView> onEdit, Consumer<CategoryView> onDelete) {
        this.onAction = onAction;
        this.onEdit = onEdit;
        this.onDelete = onDelete;
    }

    public GridCell<CategoryView> call(GridView<CategoryView> param) {
        return new GridCell<CategoryView>(){

            protected void updateItem(CategoryView item, boolean empty) {
                super.updateItem((Object)item, empty);
                this.setFocusTraversable(false);
                if (empty || item == null) {
                    this.setText(null);
                    this.setGraphic(null);
                } else {
                    this.setText(null);
                    Button btn = new Button(item.getName());
                    btn.setFocusTraversable(false);
                    btn.setContentDisplay(ContentDisplay.RIGHT);
                    if (!StringUtils.isEmpty(item.getIconCode())) {
                        btn.setGraphic((Node)GlyphFactory.createGlyph(item.getIconCode()));
                    }
                    btn.setOnAction(e -> CategoryGridCellWithMenuFactory.this.onAction.accept(item));
                    btn.setWrapText(true);
                    btn.setAlignment(Pos.BASELINE_LEFT);
                    ContextMenu menu = new ContextMenu();
                    MenuItem edit = new MenuItem("Izmena");
                    edit.setOnAction(e -> Optional.ofNullable(CategoryGridCellWithMenuFactory.this.onEdit).ifPresent(c -> c.accept(item)));
                    MenuItem delete = new MenuItem("Brisanje");
                    delete.setOnAction(e -> Optional.ofNullable(CategoryGridCellWithMenuFactory.this.onDelete).ifPresent(c -> c.accept(item)));
                    menu.getItems().addAll((Object[])new MenuItem[]{edit, delete});
                    btn.setContextMenu(menu);
                    this.setGraphic((Node)btn);
                }
            }
        };
    }
}

