/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pos.controller.factory;

import java.util.function.Consumer;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.util.Callback;
import org.controlsfx.control.GridCell;
import org.controlsfx.control.GridView;
import org.controlsfx.glyphfont.FontAwesome;
import rs.tetrabyte.xcelerate.app.factory.GlyphFactory;

public class GlyphGridCellFactory
implements Callback<GridView<FontAwesome.Glyph>, GridCell<FontAwesome.Glyph>> {
    private Consumer<String> glyphCode;

    public GlyphGridCellFactory(Consumer<String> glyphCode) {
        this.glyphCode = glyphCode;
    }

    public GridCell<FontAwesome.Glyph> call(GridView<FontAwesome.Glyph> param) {
        return new GridCell<FontAwesome.Glyph>(){

            protected void updateItem(FontAwesome.Glyph item, boolean empty) {
                super.updateItem((Object)item, empty);
                this.setFocusTraversable(false);
                if (empty || item == null) {
                    this.setText(null);
                    this.setGraphic(null);
                } else {
                    Button btn = new Button();
                    String code = "default:" + String.format("%04x", item.getChar());
                    btn.setOnAction(e -> GlyphGridCellFactory.this.glyphCode.accept(code));
                    btn.setGraphic((Node)GlyphFactory.createGlyph(code));
                    this.setGraphic((Node)btn);
                }
            }
        };
    }
}

