/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pos.controller.factory;

import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import rs.tetrabyte.pos.model.view.InvoiceItemView;
import rs.tetrabyte.pos.util.Formatter;

public class InvoiceItemCellFactory
implements Callback<ListView<InvoiceItemView>, ListCell<InvoiceItemView>> {
    private Formatter f;

    public InvoiceItemCellFactory(Formatter formatter) {
        this.f = formatter;
    }

    public ListCell<InvoiceItemView> call(ListView<InvoiceItemView> param) {
        return new ListCell<InvoiceItemView>(){

            protected void updateItem(InvoiceItemView item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (empty || item == null) {
                    this.setText(null);
                    this.setGraphic(null);
                } else {
                    this.setText(null);
                    this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
                    VBox content = new VBox();
                    Label shortName = new Label(item.getShortName());
                    content.getChildren().add((Object)shortName);
                    HBox secondLine = new HBox();
                    secondLine.setAlignment(Pos.BASELINE_RIGHT);
                    secondLine.setMaxWidth(Double.MAX_VALUE);
                    Label qty = InvoiceItemCellFactory.this.createSecondLineLabel(InvoiceItemCellFactory.this.f.qty(item.getQuantity()) + " x", 50.0);
                    Label price = InvoiceItemCellFactory.this.createSecondLineLabel(InvoiceItemCellFactory.this.f.price(item.getPrice()), 80.0);
                    Label total = InvoiceItemCellFactory.this.createSecondLineLabel(InvoiceItemCellFactory.this.f.amount(item.getTotal()), 100.0);
                    secondLine.getChildren().addAll((Object[])new Node[]{qty, price, total});
                    content.getChildren().add((Object)secondLine);
                    this.setGraphic((Node)content);
                }
            }
        };
    }

    private Label createSecondLineLabel(String text, double prefWidth) {
        Label label = new Label(text);
        label.setPrefWidth(prefWidth);
        label.setAlignment(Pos.BASELINE_RIGHT);
        return label;
    }
}

