/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pos.controller.factory;

import java.util.function.Consumer;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.util.Callback;
import org.controlsfx.control.GridCell;
import org.controlsfx.control.GridView;
import rs.tetrabyte.pos.model.view.ItemView;
import rs.tetrabyte.xcelerate.app.control.Glyph;
import rs.tetrabyte.xcelerate.app.factory.GlyphFactory;
import rs.tetrabyte.xcelerate.app.util.StringUtils;

public class ItemCellFactory
implements Callback<GridView<ItemView>, GridCell<ItemView>> {
    private Consumer<ItemView> consumer;

    public ItemCellFactory(Consumer<ItemView> consumer) {
        this.consumer = consumer;
    }

    public GridCell<ItemView> call(GridView<ItemView> param) {
        return new GridCell<ItemView>(){

            protected void updateItem(ItemView item, boolean empty) {
                super.updateItem((Object)item, empty);
                this.setFocusTraversable(false);
                if (empty || item == null) {
                    this.setText("Empty");
                    this.setGraphic(null);
                } else {
                    this.setText(null);
                    Button btn = new Button();
                    btn.setFocusTraversable(false);
                    btn.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
                    BorderPane content = new BorderPane();
                    btn.setGraphic((Node)content);
                    Label name = new Label(item.getShortName());
                    name.setWrapText(true);
                    BorderPane.setAlignment((Node)name, (Pos)Pos.TOP_LEFT);
                    content.setCenter((Node)name);
                    HBox bottom = new HBox();
                    if (!StringUtils.isEmpty(item.getIconCode())) {
                        Glyph glyph = GlyphFactory.createGlyph(item.getIconCode());
                        HBox.setHgrow((Node)glyph, (Priority)Priority.NEVER);
                        bottom.getChildren().add((Object)glyph);
                    }
                    Label price = new Label(item.getPrice().toString());
                    price.setAlignment(Pos.BASELINE_RIGHT);
                    HBox.setHgrow((Node)price, (Priority)Priority.ALWAYS);
                    price.setMaxWidth(Double.MAX_VALUE);
                    bottom.getChildren().add((Object)price);
                    bottom.setPadding(new Insets(3.0, 0.0, 0.0, 0.0));
                    content.setBottom((Node)bottom);
                    btn.setOnAction(e -> ItemCellFactory.this.consumer.accept(item));
                    btn.setWrapText(true);
                    this.setGraphic((Node)btn);
                }
            }
        };
    }
}

