/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pos.dao;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import rs.tetrabyte.pos.dao.FakeDAO;
import rs.tetrabyte.pos.dao.Page;
import rs.tetrabyte.pos.model.entity.Category;
import rs.tetrabyte.pos.repository.CategoryRepository;

@Component
public class CategoryDAO
extends FakeDAO {
    @Autowired
    private CategoryRepository categoryRepo;

    @PostConstruct
    private void generateFakeData() {
        if (this.categoryRepo.count() != 0L) {
            return;
        }
        ArrayList<Category> categories = new ArrayList<Category>();
        this.generateCategories(categories, null, 2);
        this.categoryRepo.saveAll(categories);
    }

    public List<Category> getAllCategories() {
        return this.categoryRepo.findAll();
    }

    public void deleteCategoryById(UUID categoryId) {
        this.categoryRepo.deleteById(categoryId);
    }

    public Optional<Category> getCategory(UUID id) {
        return this.categoryRepo.findById(id);
    }

    public List<Category> getRootCategories() {
        return this.categoryRepo.findByParentIsNull();
    }

    public List<Category> getChildrenCategories(Category category) {
        return this.categoryRepo.findByParent(category);
    }

    public List<Category> getLeafCategories() {
        return this.getAllCategories().stream().filter(cat -> this.getChildrenCategories((Category)cat).size() == 0).collect(Collectors.toList());
    }

    public void removeCategory(UUID id) {
        this.categoryRepo.deleteById(id);
    }

    public boolean hasChildrenCategories(Category category) {
        return !this.getChildrenCategories(category).isEmpty();
    }

    private void generateCategories(List<Category> allCat, List<Category> newCat, int depth) {
        if (depth == 0) {
            return;
        }
        if (allCat.size() == 0) {
            List<Category> list = this.generateRootCategories();
            allCat.addAll(list);
            this.generateCategories(allCat, list, depth - 1);
        } else {
            for (Category category : newCat) {
                int count = this.faker().random().nextInt(1, 10);
                List<Category> list = this.generateCategories(count, category);
                allCat.addAll(list);
                this.generateCategories(allCat, list, depth - 1);
            }
        }
    }

    private List<Category> generateCategories(int count, Category parent) {
        return this.generate(count, () -> {
            Category c = new Category();
            c.setId(UUID.randomUUID());
            c.setName(this.faker().commerce().material() + " " + this.faker().commerce().material());
            c.setIconCode(this.randomGlyphCode());
            c.setParent(parent);
            return c;
        });
    }

    private List<Category> generateRootCategories() {
        List<Category> roots = this.generateCategories(4, null);
        roots.forEach(c -> c.setName(this.faker().commerce().department()));
        return roots;
    }

    public Page<Category> getCategories(int pageSize, int pageNumber) {
        return Page.of(this.categoryRepo.findAll((Pageable)PageRequest.of((int)pageNumber, (int)pageSize)));
    }

    public void saveCategory(Category category) {
        if (category.getId() == null) {
            category.setId(UUID.randomUUID());
        }
        this.categoryRepo.save(category);
    }

    public boolean existsByName(String name) {
        return this.categoryRepo.existsByName(name);
    }
}

