/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pos.dao;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Component;
import rs.tetrabyte.pos.dao.Page;
import rs.tetrabyte.pos.model.entity.DailyReport;
import rs.tetrabyte.pos.repository.DailyReportRepository;

@Component
public class DailyReportDAO {
    @Autowired
    private DailyReportRepository reportRepo;

    private Specification<DailyReport> getSpecification(String uid, LocalDateTime startDateTime, LocalDateTime endDateTime) {
        return (Specification & Serializable)(root, query, builder) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            if (uid != null && !uid.isEmpty()) {
                predicates.add(builder.equal((Expression)root.get("uid"), (Object)uid));
            }
            if (startDateTime != null) {
                predicates.add(builder.greaterThanOrEqualTo((Expression)root.get("dateTime"), (Comparable)startDateTime));
            }
            if (endDateTime != null) {
                predicates.add(builder.lessThanOrEqualTo((Expression)root.get("dateTime"), (Comparable)endDateTime));
            }
            return builder.and((Predicate[])predicates.toArray(Predicate[]::new));
        };
    }

    public Page<DailyReport> findAll(String uid, LocalDateTime startDateTime, LocalDateTime endDateTime, int pageNumber, int pageSize) {
        return Page.of(this.reportRepo.findAll(this.getSpecification(uid, startDateTime, endDateTime), (Pageable)PageRequest.of((int)pageNumber, (int)pageSize, (Sort)Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)"dateTime")}))));
    }

    public DailyReport saveReport(DailyReport report) {
        report.setId(UUID.randomUUID());
        return (DailyReport)this.reportRepo.save(report);
    }

    public List<String> findAllUids() {
        return this.reportRepo.findDistinctUid();
    }
}

