/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pos.dao;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Optional;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import rs.tetrabyte.pos.dao.Page;
import rs.tetrabyte.pos.model.entity.Invoice;
import rs.tetrabyte.pos.repository.InvoiceItemRepository;
import rs.tetrabyte.pos.repository.InvoiceRepository;
import rs.tetrabyte.pos.sdc.InvoiceTransaction;
import rs.tetrabyte.pos.util.Specs;
import rs.tetrabyte.pos.util.StringUtil;

@Component
public class InvoiceDAO {
    @Autowired
    private InvoiceRepository invoiceRepo;
    @Autowired
    private InvoiceItemRepository invoiceItemRepo;
    private int invoiceCounter = 1000;

    @Transactional
    public void saveInvoice(Invoice invoice) {
        invoice.updateTotal();
        invoice.setId(UUID.randomUUID());
        invoice.setUid(String.valueOf(++this.invoiceCounter));
        invoice.setKeywords(this.getKeywords(invoice));
        Invoice saved = (Invoice)this.invoiceRepo.save(invoice);
        invoice.getItems().forEach(item -> item.setInvoice(saved));
        this.invoiceItemRepo.saveAll(invoice.getItems());
    }

    private String getKeywords(Invoice invoice) {
        if (invoice == null) {
            return "";
        }
        return StringUtil.toKeywords(invoice.getBuyerId(), invoice.getBuyerCostCenterId(), invoice.getInvoiceNumber(), invoice.getUid(), invoice.getCashier(), invoice.getSdcNumber());
    }

    public long getInvoiceCount() {
        return this.invoiceRepo.count();
    }

    public Optional<Invoice> getInvoiceById(UUID id) {
        return this.invoiceRepo.findById(id).map(invoice -> {
            invoice.setItems(this.invoiceItemRepo.findByInvoice((Invoice)invoice));
            return invoice;
        });
    }

    public Page<Invoice> getAllInvoices(int pageSize, int pageNumber) {
        return Page.of(this.invoiceRepo.findAll((Pageable)PageRequest.of((int)pageNumber, (int)pageSize)));
    }

    public Page<Invoice> getInvoicesByType(InvoiceTransaction type, int pageSize, int pageNumber) {
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)pageSize);
        return Page.of(this.invoiceRepo.findByTypeOrderBySdcDateTimeDesc(type, (Pageable)pageable));
    }

    public Page<Invoice> searchInvoices(String searchString, int pageSize, int pageNumber) {
        if (searchString == null || searchString.isEmpty()) {
            return Page.empty();
        }
        return Page.of(this.invoiceRepo.findAll(Specs.containsKeyword(searchString), (Pageable)PageRequest.of((int)pageNumber, (int)pageSize)));
    }

    public Page<Invoice> getInvoicesByDateAndType(LocalDate startDate, LocalDate endDate, InvoiceTransaction type, int pageSize, int pageIndex) {
        PageRequest pageable = PageRequest.of((int)pageIndex, (int)pageSize);
        LocalDateTime startDateTime = startDate.atTime(0, 0, 0);
        LocalDateTime endDateTime = endDate.atTime(23, 59, 59);
        return Page.of(this.invoiceRepo.findByTypeAndSdcDateTimeBetweenOrderBySdcDateTimeDesc(type, startDateTime, endDateTime, (Pageable)pageable));
    }
}

