/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pos.dao;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import rs.tetrabyte.pos.dao.CategoryDAO;
import rs.tetrabyte.pos.dao.FakeDAO;
import rs.tetrabyte.pos.dao.Page;
import rs.tetrabyte.pos.model.entity.Category;
import rs.tetrabyte.pos.model.entity.Item;
import rs.tetrabyte.pos.model.entity.ItemType;
import rs.tetrabyte.pos.model.entity.VatType;
import rs.tetrabyte.pos.repository.ItemRepository;
import rs.tetrabyte.pos.util.DataValidator;
import rs.tetrabyte.pos.util.Specs;
import rs.tetrabyte.pos.util.StringUtil;

@Component
public class ItemDAO
extends FakeDAO {
    private static final String[] units = new String[]{"kom", "m", "m2", "m3", "ton", "set", "kg", "g", "l"};
    @Autowired
    private CategoryDAO categoryDao;
    @Autowired
    private ItemRepository itemRepo;

    @PostConstruct
    void generateFakeData() {
        if (this.itemRepo.count() != 0L) {
            return;
        }
        List<Item> items = this.generate(2000, () -> {
            Item v = new Item();
            Object ean = this.faker().number().digits(12);
            ean = (String)ean + DataValidator.checkSumGtin((String)ean);
            v.setId(UUID.randomUUID());
            v.setEan((String)ean);
            v.setShortName(this.faker().commerce().productName());
            v.setLongName(this.faker().commerce().productName());
            v.setPrice(this.decimal(this.faker().commerce().price(10.0, 500.0)));
            v.setItemType((ItemType)this.faker().options().option(ItemType.class));
            v.setVatType((VatType)this.faker().options().option(VatType.class));
            v.setUnit((String)this.faker().options().option((Object[])units));
            v.setCategory(this.getRandomLeafCategory());
            v.setIconCode(v.getCategory().getIconCode());
            return v;
        });
        for (int i = 0; i < items.size(); ++i) {
            Item v = items.get(i);
            v.setUid("" + (i + 1));
            v.setKeywords(this.getKeywords(v));
        }
        this.itemRepo.saveAll(items);
    }

    private String getKeywords(Item item) {
        if (item == null) {
            return "";
        }
        return StringUtil.toKeywords(item.getUid(), item.getEan(), item.getShortName().toLowerCase());
    }

    public void addItem(Item item) {
        if (item == null || item.getEan() == null || item.getEan().isEmpty()) {
            throw new IllegalArgumentException("Item or EAN must not be null or empty");
        }
        Optional<Item> existingItem = this.findItemByEan(item.getEan());
        if (existingItem.isPresent() && !existingItem.get().getId().equals(item.getId())) {
            throw new IllegalArgumentException("Item with the same EAN already exists");
        }
        item.setKeywords(this.getKeywords(item));
        if (item.getId() == null) {
            item.setId(UUID.randomUUID());
        }
        this.itemRepo.save(item);
    }

    private Category getRandomLeafCategory() {
        List<Category> leafCategories = this.categoryDao.getLeafCategories();
        int random = this.faker().random().nextInt(0, leafCategories.size() - 1);
        return leafCategories.get(random);
    }

    public long getItemCount() {
        return this.itemRepo.count();
    }

    public List<Item> getAllItems() {
        return this.itemRepo.findAll((Pageable)PageRequest.of((int)0, (int)100)).getContent();
    }

    public Page<Item> getAllItems(int pageSize, int pageNumber) {
        return Page.of(this.itemRepo.findAll((Pageable)PageRequest.of((int)pageNumber, (int)pageSize)));
    }

    public List<Item> getItemsByCategory(Category category) {
        return this.getAllItems().stream().filter(item -> item.getCategory() != null && item.getCategory().getId().equals(category.getId())).collect(Collectors.toList());
    }

    public Page<Item> getItemsByCategory(Category category, int pageSize, int pageNumber) {
        return Page.of(this.itemRepo.findByCategory(category, (Pageable)PageRequest.of((int)pageNumber, (int)pageSize)));
    }

    public Page<Item> searchItems(String string, int pageSize, int pageNumber) {
        if (string.isEmpty()) {
            return Page.empty();
        }
        return Page.of(this.itemRepo.findAll(Specs.containsKeyword(string), (Pageable)PageRequest.of((int)pageNumber, (int)pageSize)));
    }

    public Optional<Item> findItemByEan(String ean) {
        if (ean == null || ean.isEmpty()) {
            return Optional.empty();
        }
        return this.itemRepo.findByEan(ean);
    }

    public Optional<Item> findItemByUid(String uid) {
        if (uid == null || uid.isEmpty()) {
            return Optional.empty();
        }
        return this.itemRepo.findByUid(uid);
    }

    public Optional<Item> removeItem(String uid) {
        Optional<Item> optionalItem = this.itemRepo.findByUid(uid);
        optionalItem.ifPresent(arg_0 -> ((ItemRepository)this.itemRepo).delete(arg_0));
        return optionalItem;
    }
}

