/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pos.model.converter;

import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.persistence.AttributeConverter;
import rs.tetrabyte.pos.model.entity.Payment;
import rs.tetrabyte.pos.model.entity.PaymentType;

public class PaymentListConverter
implements AttributeConverter<List<Payment>, String> {
    public String convertToDatabaseColumn(List<Payment> payments) {
        if (payments == null) {
            return null;
        }
        return payments.stream().map(payment -> payment.getPaymentType().getIntValue() + ":" + String.valueOf(payment.getAmount())).collect(Collectors.joining(","));
    }

    public List<Payment> convertToEntityAttribute(String string) {
        if (string == null) {
            return null;
        }
        return Stream.of(string.split("\\,")).map(exp -> {
            String[] split = exp.split("\\:");
            Payment p = new Payment();
            p.setPaymentType(PaymentType.ofIntValue(Integer.parseInt(split[0])));
            p.setAmount(new BigDecimal(split[1]));
            return p;
        }).collect(Collectors.toList());
    }
}

