/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pos.model.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.UUID;
import javax.persistence.Convert;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import rs.tetrabyte.pos.model.converter.PaymentListConverter;
import rs.tetrabyte.pos.model.entity.Customer;
import rs.tetrabyte.pos.model.entity.InvoiceItem;
import rs.tetrabyte.pos.model.entity.Payment;
import rs.tetrabyte.pos.sdc.InvoiceTransaction;

@Entity
public class Invoice {
    @Id
    private UUID id;
    private String uid;
    private LocalDateTime dateAndTimeOfIssue;
    @Embedded
    private InvoiceTransaction type;
    private String cashier;
    private String buyerId;
    private String buyerCostCenterId;
    private String invoiceNumber;
    private String referentDocumentNumber;
    private LocalDateTime referentDocumentDT;
    private LocalDateTime sdcDateTime;
    private String sdcNumber;
    private BigDecimal total = BigDecimal.ZERO;
    @Convert(converter=PaymentListConverter.class)
    private List<Payment> payment;
    @Transient
    private List<InvoiceItem> items;
    @ManyToOne
    private Customer customer;
    private String keywords;

    public BigDecimal calculateTotal() {
        return this.items.stream().map(InvoiceItem::getTotal).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public void updateTotal() {
        this.total = this.calculateTotal();
    }

    public String toString() {
        return "Invoice{id=" + String.valueOf(this.id) + ", dateAndTimeOfissue=" + String.valueOf(this.dateAndTimeOfIssue) + ", invoiceType='" + this.type.getInvoiceType() + "', transactionType='" + this.type.getTransactionType() + "', payment=" + String.valueOf(this.payment) + ", cashier='" + this.cashier + "', buyerId='" + this.buyerId + "', buyerCostCenterId='" + this.buyerCostCenterId + "', invoiceNumber='" + this.invoiceNumber + "', referentDocumentNumber='" + this.referentDocumentNumber + "', referentDocumentDT='" + String.valueOf(this.referentDocumentDT) + "',totalAmount= " + String.valueOf(this.total) + "', items=" + String.valueOf(this.items) + "}";
    }

    public UUID getId() {
        return this.id;
    }

    public String getUid() {
        return this.uid;
    }

    public LocalDateTime getDateAndTimeOfIssue() {
        return this.dateAndTimeOfIssue;
    }

    public InvoiceTransaction getType() {
        return this.type;
    }

    public String getCashier() {
        return this.cashier;
    }

    public String getBuyerId() {
        return this.buyerId;
    }

    public String getBuyerCostCenterId() {
        return this.buyerCostCenterId;
    }

    public String getInvoiceNumber() {
        return this.invoiceNumber;
    }

    public String getReferentDocumentNumber() {
        return this.referentDocumentNumber;
    }

    public LocalDateTime getReferentDocumentDT() {
        return this.referentDocumentDT;
    }

    public LocalDateTime getSdcDateTime() {
        return this.sdcDateTime;
    }

    public String getSdcNumber() {
        return this.sdcNumber;
    }

    public BigDecimal getTotal() {
        return this.total;
    }

    public List<Payment> getPayment() {
        return this.payment;
    }

    public List<InvoiceItem> getItems() {
        return this.items;
    }

    public Customer getCustomer() {
        return this.customer;
    }

    public String getKeywords() {
        return this.keywords;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public void setDateAndTimeOfIssue(LocalDateTime dateAndTimeOfIssue) {
        this.dateAndTimeOfIssue = dateAndTimeOfIssue;
    }

    public void setType(InvoiceTransaction type) {
        this.type = type;
    }

    public void setCashier(String cashier) {
        this.cashier = cashier;
    }

    public void setBuyerId(String buyerId) {
        this.buyerId = buyerId;
    }

    public void setBuyerCostCenterId(String buyerCostCenterId) {
        this.buyerCostCenterId = buyerCostCenterId;
    }

    public void setInvoiceNumber(String invoiceNumber) {
        this.invoiceNumber = invoiceNumber;
    }

    public void setReferentDocumentNumber(String referentDocumentNumber) {
        this.referentDocumentNumber = referentDocumentNumber;
    }

    public void setReferentDocumentDT(LocalDateTime referentDocumentDT) {
        this.referentDocumentDT = referentDocumentDT;
    }

    public void setSdcDateTime(LocalDateTime sdcDateTime) {
        this.sdcDateTime = sdcDateTime;
    }

    public void setSdcNumber(String sdcNumber) {
        this.sdcNumber = sdcNumber;
    }

    public void setTotal(BigDecimal total) {
        this.total = total;
    }

    public void setPayment(List<Payment> payment) {
        this.payment = payment;
    }

    public void setItems(List<InvoiceItem> items) {
        this.items = items;
    }

    public void setCustomer(Customer customer) {
        this.customer = customer;
    }

    public void setKeywords(String keywords) {
        this.keywords = keywords;
    }
}

