/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pos.sdc;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Embeddable;

@Embeddable
public class InvoiceTransaction {
    private static final Map<String, String> TYPE_MAP = new HashMap<String, String>();
    public static final InvoiceTransaction NORMAL;
    public static final InvoiceTransaction NORMAL_SALE;
    public static final InvoiceTransaction NORMAL_REFUND;
    public static final InvoiceTransaction PROFORMA_SALE;
    public static final InvoiceTransaction PROFORMA_REFUND;
    public static final InvoiceTransaction ADVANCE_SALE;
    public static final InvoiceTransaction ADVANCE_REFUND;
    public static final InvoiceTransaction COPY_SALE;
    public static final InvoiceTransaction COPY_REFUND;
    public static final InvoiceTransaction TRAINING_SALE;
    public static final InvoiceTransaction TRAINING_REFUND;
    private String invoiceType;
    private String transactionType;
    private String description;

    public InvoiceTransaction() {
    }

    public InvoiceTransaction(String invoiceType, String transactionType) {
        this.invoiceType = invoiceType;
        this.transactionType = transactionType;
        this.description = TYPE_MAP.get(invoiceType);
        if (transactionType != null) {
            this.description = this.description + " - " + TYPE_MAP.get(transactionType);
        }
    }

    public String getInvoiceType() {
        return this.invoiceType;
    }

    public String getTransactionType() {
        return this.transactionType;
    }

    public String getDescription() {
        return this.description;
    }

    public InvoiceTransaction toRefund() {
        return new InvoiceTransaction(this.invoiceType, "Refund");
    }

    public String getValue() {
        return this.getInvoiceType() + "-" + (this.getTransactionType() != null ? this.getTransactionType() : "");
    }

    public boolean isReferenceRequired() {
        return InvoiceTransaction.isReferenceRequired(this);
    }

    public boolean isReferenceOptional() {
        return InvoiceTransaction.isReferenceOptional(this);
    }

    public boolean isAdvance() {
        return InvoiceTransaction.isAdvance(this);
    }

    public String toString() {
        return this.description;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.invoiceType == null ? 0 : this.invoiceType.hashCode());
        result = 31 * result + (this.transactionType == null ? 0 : this.transactionType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InvoiceTransaction other = (InvoiceTransaction)obj;
        if (this.invoiceType == null ? other.invoiceType != null : !this.invoiceType.equals(other.invoiceType)) {
            return false;
        }
        return !(this.transactionType == null ? other.transactionType != null : !this.transactionType.equals(other.transactionType));
    }

    public static InvoiceTransaction of(String invoiceTransaction) {
        String[] split = invoiceTransaction.split("\\-");
        return new InvoiceTransaction(split[0], split[1]);
    }

    public static InvoiceTransaction[] getAll() {
        return new InvoiceTransaction[]{NORMAL_SALE, NORMAL_REFUND, PROFORMA_SALE, PROFORMA_REFUND, ADVANCE_SALE, ADVANCE_REFUND, COPY_SALE, COPY_REFUND, TRAINING_SALE, TRAINING_REFUND};
    }

    public static InvoiceTransaction[] getExtended() {
        return new InvoiceTransaction[]{NORMAL, NORMAL_SALE, NORMAL_REFUND, PROFORMA_SALE, PROFORMA_REFUND, ADVANCE_SALE, ADVANCE_REFUND, COPY_SALE, COPY_REFUND, TRAINING_SALE, TRAINING_REFUND};
    }

    public static boolean isReferenceRequired(InvoiceTransaction it) {
        return Arrays.asList(NORMAL_REFUND, PROFORMA_REFUND, ADVANCE_REFUND, COPY_SALE, COPY_REFUND, TRAINING_REFUND).contains(it);
    }

    public static boolean isReferenceOptional(InvoiceTransaction it) {
        return Arrays.asList(NORMAL_SALE, ADVANCE_SALE).contains(it) || InvoiceTransaction.isReferenceRequired(it);
    }

    public static boolean isAdvance(InvoiceTransaction it) {
        return Arrays.asList(ADVANCE_SALE, ADVANCE_REFUND).contains(it);
    }

    static {
        TYPE_MAP.put("Normal", "PROMET");
        TYPE_MAP.put("Proforma", "PREDRA\u010cUN");
        TYPE_MAP.put("Advance", "AVANS");
        TYPE_MAP.put("Copy", "KOPIJA");
        TYPE_MAP.put("Training", "OBUKA");
        TYPE_MAP.put("Sale", "PRODAJA");
        TYPE_MAP.put("Refund", "REFUNDACIJA");
        NORMAL = new InvoiceTransaction("Normal", null);
        NORMAL_SALE = new InvoiceTransaction("Normal", "Sale");
        NORMAL_REFUND = new InvoiceTransaction("Normal", "Refund");
        PROFORMA_SALE = new InvoiceTransaction("Proforma", "Sale");
        PROFORMA_REFUND = new InvoiceTransaction("Proforma", "Refund");
        ADVANCE_SALE = new InvoiceTransaction("Advance", "Sale");
        ADVANCE_REFUND = new InvoiceTransaction("Advance", "Refund");
        COPY_SALE = new InvoiceTransaction("Copy", "Sale");
        COPY_REFUND = new InvoiceTransaction("Copy", "Refund");
        TRAINING_SALE = new InvoiceTransaction("Training", "Sale");
        TRAINING_REFUND = new InvoiceTransaction("Training", "Refund");
    }
}

