/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pos.sdc;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.imageio.ImageIO;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import rs.tetrabyte.pos.sdc.SDCException;
import rs.tetrabyte.pos.sdc.model.InvoiceRequest;
import rs.tetrabyte.pos.sdc.model.InvoiceRequestEntity;
import rs.tetrabyte.pos.sdc.model.InvoiceResponse;
import rs.tetrabyte.pos.sdc.model.InvoiceResponseEntity;
import rs.tetrabyte.pos.sdc.model.StatusResponse;
import rs.tetrabyte.pos.sdc.model.TaxGroup;
import rs.tetrabyte.pos.sdc.model.report.Report;

@Component
public class SDCClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(SDCClient.class);
    private static final String BASE_URI = "http://localhost:8989";
    private static final String AGENT_URI = "http://localhost:8989/agent/v3";
    private static final String EXTENSION_URI = "http://localhost:8989/extension/v3";
    private HttpClient client = HttpClientBuilder.create().setDefaultRequestConfig(RequestConfig.custom().setConnectionRequestTimeout(60000).setConnectTimeout(10000).setSocketTimeout(10000).build()).build();
    private Gson gson;
    private static final Map<String, String> statusMap = new HashMap<String, String>();

    public SDCClient(GsonBuilder gsonBuilder) {
        this.gson = gsonBuilder.create();
    }

    private String agentApi(String name) {
        return "http://localhost:8989/agent/v3/" + name;
    }

    private String extensionApi(String name) {
        return "http://localhost:8989/extension/v3/" + name;
    }

    private HttpResponse executeRestCall(HttpUriRequest request) throws SDCException {
        try {
            return this.client.execute(request);
        }
        catch (ClientProtocolException e) {
            throw new SDCException("Gre\u0161ka u komunikaciji", e);
        }
        catch (IOException e) {
            throw new SDCException("Nije uspelo povezivanje sa L-PFR servisom. Proverite da li je servis aktivan.", e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private <T> T deserialize(HttpEntity entity, Class<T> type) throws SDCException {
        try (InputStream is = entity.getContent();){
            Object object;
            try (InputStreamReader reader = new InputStreamReader(is);){
                object = this.gson.fromJson((Reader)reader, type);
            }
            return (T)object;
        }
        catch (JsonIOException | JsonSyntaxException | IOException e) {
            e.printStackTrace();
            throw new SDCException("Greska prilikom \u010ditanja primljenih podataka", e);
        }
    }

    public String verifyPIN(String pin) throws SDCException {
        String uri = this.agentApi("/pin");
        HttpPost post = new HttpPost(uri);
        post.addHeader("Content-Type", "application/json");
        try {
            post.setEntity((HttpEntity)new StringEntity(pin));
            HttpResponse httpResponse = this.executeRestCall((HttpUriRequest)post);
            String lpfrStatus = this.readResponseCode(httpResponse);
            return statusMap.getOrDefault(lpfrStatus, lpfrStatus);
        }
        catch (UnsupportedEncodingException e) {
            throw new SDCException("Nepoznata greska", e);
        }
    }

    public boolean isPinRequired() throws SDCException {
        String code = this.attention();
        return "1500".equals(code);
    }

    public String attention() throws SDCException {
        String uri = this.agentApi("/attention");
        return this.readResponse(this.executeRestCall((HttpUriRequest)new HttpGet(uri)));
    }

    public List<TaxGroup.TaxCategory.TaxRate> getTaxRates() throws SDCException {
        String uri = this.agentApi("/status");
        HttpResponse httpResponse = this.executeRestCall((HttpUriRequest)new HttpGet(uri));
        StatusResponse response = this.deserialize(httpResponse.getEntity(), StatusResponse.class);
        ArrayList<TaxGroup.TaxCategory.TaxRate> rates = new ArrayList<TaxGroup.TaxCategory.TaxRate>();
        for (TaxGroup.TaxCategory cat : response.getCurrentTaxRates().getTaxCategories()) {
            rates.addAll(cat.getTaxRates());
        }
        return rates;
    }

    public Report getDailyReport(boolean closeDay) throws SDCException {
        String uri = this.extensionApi("/reports/daily");
        HttpGet get = new HttpGet(uri);
        get.addHeader("CloseDay", String.valueOf(closeDay));
        HttpResponse response = this.executeRestCall((HttpUriRequest)get);
        return this.deserialize(response.getEntity(), Report.class);
    }

    public Report printDailyReport(boolean closeDay) throws SDCException {
        String uri = this.agentApi("/reports/daily");
        HttpGet get = new HttpGet(uri);
        get.addHeader("CloseDay", String.valueOf(closeDay));
        HttpResponse response = this.executeRestCall((HttpUriRequest)get);
        return this.deserialize(response.getEntity(), Report.class);
    }

    public Report getPeriodicReport(LocalDate startDate, LocalDate endDate) throws SDCException {
        String uri = this.extensionApi("/reports/periodic");
        HttpGet get = new HttpGet(uri);
        Optional.ofNullable(startDate).or(() -> Optional.of(LocalDate.now())).ifPresent(date -> get.addHeader("StartDate", date.toString()));
        Optional.ofNullable(endDate).or(() -> Optional.of(LocalDate.now())).ifPresent(date -> get.addHeader("EndDate", date.toString()));
        HttpResponse response = this.executeRestCall((HttpUriRequest)get);
        return this.deserialize(response.getEntity(), Report.class);
    }

    public Report printPeriodicReport(LocalDate startDate, LocalDate endDate) throws SDCException {
        String uri = this.agentApi("/reports/periodic");
        HttpGet get = new HttpGet(uri);
        Optional.ofNullable(startDate).or(() -> Optional.of(LocalDate.now())).ifPresent(date -> get.addHeader("StartDate", date.toString()));
        Optional.ofNullable(endDate).or(() -> Optional.of(LocalDate.now())).ifPresent(date -> get.addHeader("EndDate", date.toString()));
        HttpResponse response = this.executeRestCall((HttpUriRequest)get);
        return this.deserialize(response.getEntity(), Report.class);
    }

    public InvoiceResponse createInvoice(InvoiceRequest request) throws SDCException {
        InvoiceRequestEntity entity = request.getEntity();
        String json = this.gson.toJson((Object)entity);
        HttpPost post = new HttpPost(this.agentApi("invoices"));
        post.addHeader("Content-Type", "application/json");
        post.addHeader("RequestId", request.getId());
        post.setEntity((HttpEntity)new StringEntity(json, StandardCharsets.UTF_8));
        HttpResponse httpResponse = this.executeRestCall((HttpUriRequest)post);
        int status = httpResponse.getStatusLine().getStatusCode();
        if (status == 400) {
            throw new SDCException("Greska! Podaci nisu dobro formatirani.\r\n" + this.readResponse(httpResponse));
        }
        if (status == 423) {
            String lpfrStatus = this.readResponseCode(httpResponse);
            throw new SDCException(statusMap.get(lpfrStatus));
        }
        if (status == 406) {
            throw new SDCException("Jezik nije podr\u017ean");
        }
        if (status == 200) {
            InvoiceResponse.InvoiceResponseBuilder responseBuilder = InvoiceResponse.builder();
            responseBuilder.entity(this.deserialize(httpResponse.getEntity(), InvoiceResponseEntity.class));
            try {
                responseBuilder.image(this.getInvoiceImage(request.getId()));
            }
            catch (Exception e) {
                LOGGER.error("Neuspelo preuzimanje slike racuna", (Throwable)e);
            }
            return responseBuilder.build();
        }
        throw new SDCException("Potpisivanje ra\u010duna nije uspelo usled neo\u010dekivane gre\u0161ke");
    }

    private BufferedImage getInvoiceImage(String requestId) throws SDCException, IOException {
        String uri = this.agentApi("receipts/" + requestId);
        HttpGet get = new HttpGet(uri);
        HttpResponse httpResponse = this.executeRestCall((HttpUriRequest)get);
        try (InputStream is = httpResponse.getEntity().getContent();){
            BufferedImage image = ImageIO.read(is);
            BufferedImage receipt = new BufferedImage(image.getWidth(), image.getHeight(), 2);
            Graphics2D g2d = (Graphics2D)receipt.getGraphics();
            g2d.setBackground(Color.WHITE);
            g2d.clearRect(0, 0, image.getWidth(), image.getHeight());
            g2d.drawImage((Image)image, 0, 0, null);
            g2d.dispose();
            BufferedImage bufferedImage = receipt;
            return bufferedImage;
        }
    }

    private String readResponse(HttpResponse response) throws SDCException {
        String string;
        BufferedReader reader = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
        try {
            StringBuffer buffer = new StringBuffer();
            String line = reader.readLine();
            while (line != null) {
                buffer.append(line);
                line = reader.readLine();
            }
            string = buffer.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new SDCException("Nije uspelo \u010ditanje odgovora od L-PFR-a", e);
            }
        }
        reader.close();
        return string;
    }

    private String readResponseCode(HttpResponse response) throws SDCException {
        return this.readResponse(response).replace("\"", "");
    }

    public static String getMessage(String lpfrStatus) {
        return statusMap.get(lpfrStatus);
    }

    static {
        statusMap.put("0210", "Internet je dostupan");
        statusMap.put("0220", "Internet nije dostupan. Daljinsko i\u0161\u010ditavanje nemogu\u0107e.");
        statusMap.put("1100", "Suvi\u0161e malo slobodnog prostora na disku. Neophodna akcija korisnika.");
        statusMap.put("1300", "Smart kartica nije prisutna. Dalji rad nemogu\u0107.");
        statusMap.put("1400", "Upozorenje! I\u0161\u010ditavanje je neophodno. Suma na kartici je pre\u0161la 75% od dozvoljenog limita.");
        statusMap.put("1500", "Operacija se ne mo\u017ee izvr\u0161iti bez prethodno unetog PIN koda.");
        statusMap.put("1999", "Nedefinisana gre\u0161ka");
        statusMap.put("2100", "Pogre\u0161an PIN kod.");
        statusMap.put("2110", "Smart kartica je zaklju\u010dana. Suvi\u0161e pogre\u0161nih poku\u0161aja unosa PIN koda.");
        statusMap.put("2130", "Licenca za upotrebu softvera nije prona\u0111ena");
        statusMap.put("2131", "Licenca za upotrebu softvera je istekla");
        statusMap.put("2132", "Neispravna licenca za upotrebu softvera");
        statusMap.put("2210", "Bezbednosni element je zaklju\u010dan. Neophodno i\u0161\u010ditavanje za nastavak rada.");
        statusMap.put("2220", "Gre\u0161ka prilikom komunikacije sa bezbednosnim elementom.");
        statusMap.put("2240", "Ra\u010dun ne mo\u017ee biti potpisan jer vreme ure\u0111aja nije logi\u010dno!");
        statusMap.put("2250", "Operacija se ne mo\u017ee izvr\u0161iti. Suvi\u0161e malo slobodnog prostora na disku.");
        statusMap.put("2251", "Operacija se ne mo\u017ee izvr\u0161iti. Suvi\u0161e malo slobodne memorije.");
        statusMap.put("2260", "Aplikacija se a\u017eurira. Molimo, sa\u010dekajte.");
        statusMap.put("2400", "LPFR nije konfigurisan. Neophodan unos PIN koda za nastavak rada.");
    }
}

