/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pos.sdc.model;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class InvoiceItem {
    private String gtin;
    private String name;
    private BigDecimal quantity;
    private BigDecimal unitPrice;
    private BigDecimal totalAmount;
    private List<String> labels;

    InvoiceItem(String gtin, String name, BigDecimal quantity, BigDecimal unitPrice, BigDecimal totalAmount, List<String> labels) {
        this.gtin = gtin;
        this.name = name;
        this.quantity = quantity;
        this.unitPrice = unitPrice;
        this.totalAmount = totalAmount;
        this.labels = labels;
    }

    public static InvoiceItemBuilder builder() {
        return new InvoiceItemBuilder();
    }

    public String getGtin() {
        return this.gtin;
    }

    public String getName() {
        return this.name;
    }

    public BigDecimal getQuantity() {
        return this.quantity;
    }

    public BigDecimal getUnitPrice() {
        return this.unitPrice;
    }

    public BigDecimal getTotalAmount() {
        return this.totalAmount;
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public static class InvoiceItemBuilder {
        private String gtin;
        private String name;
        private BigDecimal quantity;
        private BigDecimal unitPrice;
        private BigDecimal totalAmount;
        private List<String> labels;

        public InvoiceItemBuilder label(String label) {
            if (this.labels == null) {
                this.labels = new ArrayList<String>();
            }
            this.labels.add(label);
            return this;
        }

        InvoiceItemBuilder() {
        }

        public InvoiceItemBuilder gtin(String gtin) {
            this.gtin = gtin;
            return this;
        }

        public InvoiceItemBuilder name(String name) {
            this.name = name;
            return this;
        }

        public InvoiceItemBuilder quantity(BigDecimal quantity) {
            this.quantity = quantity;
            return this;
        }

        public InvoiceItemBuilder unitPrice(BigDecimal unitPrice) {
            this.unitPrice = unitPrice;
            return this;
        }

        public InvoiceItemBuilder totalAmount(BigDecimal totalAmount) {
            this.totalAmount = totalAmount;
            return this;
        }

        public InvoiceItemBuilder labels(List<String> labels) {
            this.labels = labels;
            return this;
        }

        public InvoiceItem build() {
            return new InvoiceItem(this.gtin, this.name, this.quantity, this.unitPrice, this.totalAmount, this.labels);
        }

        public String toString() {
            return "InvoiceItem.InvoiceItemBuilder(gtin=" + this.gtin + ", name=" + this.name + ", quantity=" + String.valueOf(this.quantity) + ", unitPrice=" + String.valueOf(this.unitPrice) + ", totalAmount=" + String.valueOf(this.totalAmount) + ", labels=" + String.valueOf(this.labels) + ")";
        }
    }
}

