/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pos.sdc.serialization;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public class LocalDateTimeTypeAdapter
extends TypeAdapter<LocalDateTime> {
    public void write(JsonWriter jsonWriter, LocalDateTime localDate) throws IOException {
        if (localDate == null) {
            jsonWriter.nullValue();
            return;
        }
        jsonWriter.value(DateTimeFormatter.ISO_DATE_TIME.format(localDate));
    }

    public LocalDateTime read(JsonReader jsonReader) throws IOException {
        if (jsonReader.peek() == JsonToken.NULL) {
            jsonReader.nextNull();
            return null;
        }
        return (LocalDateTime)DateTimeFormatter.ISO_LOCAL_DATE_TIME.parse(jsonReader.nextString());
    }
}

