/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pos.service;

import java.util.List;
import java.util.stream.Collectors;
import org.modelmapper.AbstractConverter;
import org.modelmapper.Converter;
import org.modelmapper.ModelMapper;
import org.springframework.stereotype.Service;
import rs.tetrabyte.pos.model.entity.Invoice;
import rs.tetrabyte.pos.model.entity.InvoiceItem;
import rs.tetrabyte.pos.model.view.InvoiceItemView;
import rs.tetrabyte.pos.model.view.InvoiceView;

@Service
public class InvoiceCancellationService {
    private final ModelMapper mapper = new ModelMapper();

    public InvoiceCancellationService() {
        this.mapper.typeMap(Invoice.class, InvoiceView.class).addMappings(mapper -> mapper.using(this.getInvoiceItemToInvoiceItemViewConverter()).map(Invoice::getItems, InvoiceView::setItems));
    }

    public InvoiceView mapInvoiceToView(Invoice invoice) {
        return (InvoiceView)this.mapper.map((Object)invoice, InvoiceView.class);
    }

    public List<InvoiceItemView> mapItemsToView(List<InvoiceItem> items) {
        return items.stream().map(item -> (InvoiceItemView)this.mapper.map(item, InvoiceItemView.class)).collect(Collectors.toList());
    }

    private Converter<List<InvoiceItem>, List<InvoiceItemView>> getInvoiceItemToInvoiceItemViewConverter() {
        return new AbstractConverter<List<InvoiceItem>, List<InvoiceItemView>>(){

            protected List<InvoiceItemView> convert(List<InvoiceItem> source) {
                if (source == null) {
                    return null;
                }
                return source.stream().map(item -> (InvoiceItemView)InvoiceCancellationService.this.mapper.map(item, InvoiceItemView.class)).collect(Collectors.toList());
            }
        };
    }
}

