/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pos.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.modelmapper.ModelMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import rs.tetrabyte.pos.dao.CategoryDAO;
import rs.tetrabyte.pos.dao.ItemDAO;
import rs.tetrabyte.pos.dao.Page;
import rs.tetrabyte.pos.model.entity.Category;
import rs.tetrabyte.pos.model.entity.Item;
import rs.tetrabyte.pos.model.view.CategoryView;
import rs.tetrabyte.pos.model.view.ItemView;
import rs.tetrabyte.xcelerate.core.task.AbstractTask;
import rs.tetrabyte.xcelerate.core.task.TaskFactory;
import rs.tetrabyte.xcelerate.core.task.UIAccessor;

@Service
public class ItemService {
    @Autowired
    private ItemDAO itemDao;
    @Autowired
    private CategoryDAO categoryDao;
    @Autowired
    private TaskFactory taskFactory;
    @Autowired
    private UIAccessor uiAccessor;
    private final ModelMapper mapper = new ModelMapper();

    public void addItem(ItemView itemView) {
        Item item = (Item)this.mapper.map((Object)itemView, Item.class);
        this.itemDao.addItem(item);
    }

    public Page<ItemView> getAllItems(int pageSize, int pageNumber) {
        return this.mapPage(this.itemDao.getAllItems(pageSize, pageNumber));
    }

    public long getItemCount() {
        return this.itemDao.getItemCount();
    }

    public List<ItemView> getItemsByCategory(CategoryView view) {
        return this.mapList(this.categoryDao.getCategory(view.getId()).map(this.itemDao::getItemsByCategory).orElse(new ArrayList()));
    }

    public Page<ItemView> getItemsByCategory(CategoryView view, int pageSize, int pageNumber) {
        return this.mapPage(this.categoryDao.getCategory(view.getId()).map(cat -> this.itemDao.getItemsByCategory((Category)cat, pageSize, pageNumber)).orElse(Page.empty()));
    }

    public Page<ItemView> searchItems(String string, int pageSize, int pageNumber) {
        return this.mapPage(this.itemDao.searchItems(string, pageSize, pageNumber));
    }

    public Optional<ItemView> findItemByEan(String ean) {
        return this.itemDao.findItemByEan(ean).map(item -> (ItemView)this.mapper.map(item, ItemView.class));
    }

    public Optional<ItemView> findItemByUid(String uid) {
        return this.itemDao.findItemByUid(uid).map(item -> (ItemView)this.mapper.map(item, ItemView.class));
    }

    private List<ItemView> mapList(List<Item> items) {
        return items.stream().map(c -> (ItemView)this.mapper.map(c, ItemView.class)).collect(Collectors.toList());
    }

    private Page<ItemView> mapPage(Page<Item> page) {
        return new Page<ItemView>(page.getPageSize(), page.getPageCount(), page.getPageNumber(), page.getTotalCount(), this.mapList(page.getData()));
    }

    public ObservableList<ItemView> filterItemsById(ObservableList<ItemView> items, String idText) {
        if (idText == null || idText.isEmpty()) {
            return items;
        }
        ObservableList filteredItems = FXCollections.observableArrayList();
        for (ItemView item : items) {
            if (!item.getUid().contains(idText)) continue;
            filteredItems.add((Object)item);
        }
        return filteredItems;
    }

    public void removeItemAsync(String uid, ObservableList<ItemView> items) {
        ((AbstractTask)((Object)this.taskFactory.createTask(() -> this.itemDao.removeItem(uid)).uiAccessor(this.uiAccessor))).execute(optional -> {
            if (optional.isPresent()) {
                items.removeIf(view -> view.getUid().equals(uid));
            }
        });
    }
}

