/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pos.service;

import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.scene.Node;
import javafx.scene.control.TextField;
import javafx.scene.effect.Effect;
import javafx.scene.effect.GaussianBlur;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.StackPane;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import rs.tetrabyte.pos.controller.KeyboardController;
import rs.tetrabyte.xcelerate.app.commands.UICommands;
import rs.tetrabyte.xcelerate.core.fxml.FXMLTaskFactory;
import rs.tetrabyte.xcelerate.core.task.AbstractTask;

@Service
public class KeyboardService {
    @Autowired
    private FXMLTaskFactory factory;
    @Autowired
    private UICommands uiCommands;
    private StackPane parent;
    private TextField inputField;
    private Node keyBoardView;
    private boolean clearOnSave;

    public void showKeybooard() {
        if (this.keyBoardView != null && this.parent.getChildren().contains((Object)this.keyBoardView)) {
            return;
        }
        ((AbstractTask)((Object)this.factory.createTask(KeyboardController.class).whenDone(v -> {
            this.keyBoardView = v.getView();
            this.applyBlurEffect();
            this.parent.getChildren().add(v.getView());
            ((KeyboardController)v.getController()).setConsumer(this::fireKeyEvent);
        }))).execute();
    }

    public void deleteKeyboard() {
        this.parent.getChildren().remove((Object)this.keyBoardView);
        this.deleteBlurEffect();
        if (this.clearOnSave) {
            this.inputField.clear();
        }
    }

    public void fireKeyEvent(KeyCode code) {
        if (this.inputField != null) {
            this.inputField.fireEvent((Event)new KeyEvent(KeyEvent.KEY_TYPED, code.getChar(), "", KeyCode.UNDEFINED, false, false, false, false));
        }
    }

    public void saveKeyboard() {
        if (this.inputField != null) {
            this.inputField.fireEvent((Event)new ActionEvent());
            this.deleteKeyboard();
        }
    }

    public void applyBlurEffect() {
        GaussianBlur blur = new GaussianBlur();
        blur.setRadius(5.0);
        Node lastNode = (Node)this.parent.getChildren().get(this.parent.getChildren().size() - 1);
        lastNode.setEffect((Effect)blur);
    }

    public void deleteBlurEffect() {
        Node lastNode = (Node)this.parent.getChildren().get(this.parent.getChildren().size() - 1);
        lastNode.setEffect(null);
    }

    public void setInputField(TextField inputField, boolean clearOnSave) {
        if (this.inputField != null) {
            this.inputField.setOnMouseClicked(null);
        }
        this.inputField = inputField;
        this.clearOnSave = clearOnSave;
        inputField.setOnMouseClicked(e -> {
            if (e.getClickCount() == 2 && inputField.getStyleClass().contains((Object)"keyboard-enabled")) {
                this.showKeybooard();
            }
        });
    }

    public void setInputField(TextField inputField) {
        this.setInputField(inputField, false);
    }

    public void setParent(StackPane parent) {
        this.parent = parent;
    }

    public TextField getInputField() {
        return this.inputField;
    }
}

