/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pos.service;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.scene.Scene;
import javafx.scene.control.TextInputDialog;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import rs.tetrabyte.pos.model.entity.CustomerType;
import rs.tetrabyte.pos.model.view.CustomerView;
import rs.tetrabyte.pos.model.view.InvoiceView;
import rs.tetrabyte.pos.sdc.SDCClient;
import rs.tetrabyte.pos.sdc.SDCException;
import rs.tetrabyte.pos.sdc.model.InvoiceItem;
import rs.tetrabyte.pos.sdc.model.InvoicePayment;
import rs.tetrabyte.pos.sdc.model.InvoiceRequest;
import rs.tetrabyte.pos.sdc.model.InvoiceRequestEntity;
import rs.tetrabyte.pos.sdc.model.InvoiceResponse;
import rs.tetrabyte.pos.sdc.model.TaxGroup;
import rs.tetrabyte.pos.sdc.model.report.Report;
import rs.tetrabyte.pos.service.VatTypeMapService;
import rs.tetrabyte.pos.util.StringUtil;
import rs.tetrabyte.xcelerate.app.commands.UICommands;
import rs.tetrabyte.xcelerate.core.task.AbstractTask;
import rs.tetrabyte.xcelerate.core.task.TaskFactory;

@Service
public class SDCService {
    @Autowired
    private SDCClient sdcClient;
    @Autowired
    private VatTypeMapService vatMapService;
    @Autowired
    TaskFactory taskFactory;
    @Autowired
    Scene scene;
    @Autowired
    UICommands uiCommands;

    public InvoiceResponse createInvoice(InvoiceView invoice) throws SDCException {
        if (!this.vatMapService.isConfigured()) {
            throw new SDCException("Poreske stope nisu konfigurisane. Nastavak rada nije mogu\u0107.");
        }
        InvoiceRequestEntity.InvoiceRequestEntityBuilder entityBuilder = InvoiceRequestEntity.builder().cashier(invoice.getCashier()).buyerId(invoice.getBuyerId()).buyerCostCenterId(invoice.getBuyerCostCenterId()).dateAndTimeOfIssue(invoice.getDateAndTimeOfIssue()).invoiceType(invoice.getType().getInvoiceType()).transactionType(invoice.getType().getTransactionType()).referentDocumentDT(invoice.getReferentDocumentDT()).referentDocumentNumber(invoice.getReferentDocumentNumber()).payment(invoice.getPayment().stream().map(p -> InvoicePayment.builder().paymentType(p.getPaymentType().name()).amount(p.getAmount()).build()).collect(Collectors.toList())).items(invoice.getItems().stream().map(i -> InvoiceItem.builder().name(i.getShortName()).quantity(this.scale(i.getQuantity(), 3)).unitPrice(this.scale(i.getPrice(), 2)).totalAmount(this.scale(i.getTotal(), 2)).gtin(i.getEan()).label(this.vatMapService.getLabelForVatType(i.getVatType())).build()).collect(Collectors.toList()));
        if (invoice.getCustomer() != null) {
            CustomerView customer = invoice.getCustomer();
            entityBuilder.message("PODACI O KUPCU: ");
            if (customer.getType() == CustomerType.LEGAL_PERSON) {
                entityBuilder.message(customer.getName()).message("PIB: " + customer.getTin()).message("MBR: " + customer.getNationalId()).message("ADRESA: " + customer.getAddress()).message("MESTO: " + customer.getCity());
            } else if (customer.getType() == CustomerType.INDIVIDUAL_PERSON) {
                entityBuilder.message(customer.getName());
                if (customer.getNationalId() != null && !customer.getNationalId().isEmpty()) {
                    entityBuilder.message("JMBG: " + customer.getNationalId());
                }
            }
        }
        if (!StringUtil.isBlank(invoice.getMessage())) {
            entityBuilder.message("");
            entityBuilder.message(invoice.getMessage());
        }
        return this.sdcClient.createInvoice(InvoiceRequest.builder().id(invoice.getId().toString()).entity(entityBuilder.build()).build());
    }

    private BigDecimal scale(BigDecimal value, int scale) {
        return value.setScale(scale, RoundingMode.HALF_UP);
    }

    public boolean isPinRequired() throws SDCException {
        return this.sdcClient.isPinRequired();
    }

    public String verifyPin(String pin) throws SDCException {
        String response = this.sdcClient.verifyPIN(pin);
        if (response != null && !response.equals("0100")) {
            throw new SDCException(response);
        }
        return response;
    }

    public List<TaxGroup.TaxCategory.TaxRate> getTaxRates() throws SDCException {
        return this.sdcClient.getTaxRates();
    }

    public boolean isSdcAvailable() {
        try {
            this.sdcClient.attention();
            return true;
        }
        catch (SDCException e) {
            return false;
        }
    }

    public String attention() throws SDCException {
        return this.sdcClient.attention();
    }

    public void verifyPin(Runnable r) {
        ((AbstractTask)((Object)this.taskFactory.createTask(() -> this.isPinRequired()).whenDone(isPinRequired -> {
            if (isPinRequired.booleanValue()) {
                TextInputDialog pinDialog = new TextInputDialog();
                pinDialog.initOwner(this.scene.getWindow());
                pinDialog.setTitle("PIN Verifikacija");
                pinDialog.setHeaderText("Unesite PIN za potvrdu");
                pinDialog.setContentText("PIN:");
                Optional result = pinDialog.showAndWait();
                if (result.isEmpty() || ((String)result.get()).isBlank()) {
                    this.uiCommands.showAlert().error().withTitle("Gre\u0161ka", new Object[0]).withMessage("Morate uneti PIN za nastavak.", new Object[0]).execute();
                    return;
                }
                ((AbstractTask)((Object)((Object)this.taskFactory.createTask(() -> this.verifyPin((String)result.get())).whenDone(responseCode -> r.run())))).execute();
            } else {
                r.run();
            }
        }))).execute();
    }

    public Report getDailyReport(boolean closeDay) throws SDCException {
        return this.sdcClient.getDailyReport(closeDay);
    }

    public Report printDailyReport(boolean closeDay) throws SDCException {
        return this.sdcClient.printDailyReport(closeDay);
    }

    public Report getPeriodicReport(LocalDate startDate, LocalDate endDate) throws SDCException {
        return this.sdcClient.getPeriodicReport(startDate, endDate);
    }

    public Report printPeriodicReport(LocalDate startDate, LocalDate endDate) throws SDCException {
        return this.sdcClient.printPeriodicReport(startDate, endDate);
    }
}

