/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pos.service;

import java.util.List;
import java.util.stream.Collectors;
import org.modelmapper.ModelMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import rs.tetrabyte.pos.dao.VatTypeMapDAO;
import rs.tetrabyte.pos.model.entity.VatType;
import rs.tetrabyte.pos.model.entity.VatTypeMap;
import rs.tetrabyte.pos.model.view.VatTypeMapView;

@Service
public class VatTypeMapService {
    @Autowired
    private VatTypeMapDAO mapDAO;
    private ModelMapper mapper = new ModelMapper();

    public void save(VatTypeMapView view) {
        VatTypeMap value = (VatTypeMap)this.mapper.map((Object)view, VatTypeMap.class);
        this.mapDAO.save(value);
    }

    public List<VatTypeMapView> findAll() {
        return this.mapDAO.findAll().stream().map(value -> (VatTypeMapView)this.mapper.map(value, VatTypeMapView.class)).collect(Collectors.toList());
    }

    public void saveAll(List<VatTypeMapView> list) {
        this.mapDAO.saveAll(list.stream().map(value -> (VatTypeMap)this.mapper.map(value, VatTypeMap.class)).collect(Collectors.toList()));
    }

    public String getLabelForVatType(VatType vatType) {
        return this.mapDAO.getLabelForVatType(vatType);
    }

    public boolean isConfigured() {
        boolean configured = true;
        List<VatTypeMap> map = this.mapDAO.findAll();
        for (int i = 0; i < VatType.values().length && configured; ++i) {
            VatType type = VatType.values()[i];
            configured = map.stream().filter(value -> value.getVatType() == type).findAny().isPresent();
        }
        return configured;
    }
}

