/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pos.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;

public class DataValidator {
    public static boolean isPIBValid(String string) {
        if (string == null || !string.matches("\\d{9,9}")) {
            return false;
        }
        String value = string.substring(0, 8);
        int last = DataValidator.parseInt(string.charAt(8));
        return last == DataValidator.checkSumPIB(value);
    }

    public static boolean isMBValid(String string) {
        String value;
        int cs;
        if (string == null || !string.matches("\\d{8,8}")) {
            return false;
        }
        int last = DataValidator.parseInt(string.charAt(7));
        return last == (cs = DataValidator.checkSumMB(value = string.substring(0, 7)));
    }

    public static boolean isJMBGValid(String string) {
        if (string == null || !string.matches("\\d{13,13}")) {
            return false;
        }
        int last = DataValidator.parseInt(string.charAt(12));
        if (DataValidator.isDateValid(string.substring(0, 7), "ddMMyyy")) {
            int cs = DataValidator.mod11(string.substring(0, 12));
            cs = cs == 11 ? 0 : (cs == 10 ? 99 : cs);
            return "^60|66$".matches(string.substring(7, 9)) || last == cs;
        }
        return false;
    }

    public static boolean isGTINValid(String gtin) {
        if (gtin.length() != 8 && gtin.length() != 12 && gtin.length() != 13 && gtin.length() != 14 || !gtin.matches("\\d*")) {
            return false;
        }
        int last = DataValidator.parseInt(gtin.charAt(gtin.length() - 1));
        String value = gtin.substring(0, gtin.length() - 1);
        int cs = DataValidator.checkSumGtin(value);
        return cs == last;
    }

    public static int checkSumGtin(String value) {
        int sum = 0;
        int length = value.length() + 1;
        for (int i = 0; i < length - 1; ++i) {
            int digit = Character.getNumericValue(value.charAt(i));
            sum += digit * (i % 2 == (length % 2 == 0 ? 0 : 1) ? 3 : 1);
        }
        return (10 - sum % 10) % 10;
    }

    public static int checkSumPIB(String value) {
        return DataValidator.checkSumPIB(value, 10);
    }

    private static int checkSumPIB(String string, int i) {
        int first = DataValidator.parseInt(string.charAt(0));
        int cs = (first + i) % 10;
        cs = (cs != 0 ? cs : 10) * 2 % 11;
        if (string.length() == 1) {
            return (11 - cs) % 10;
        }
        return DataValidator.checkSumPIB(string.substring(1), cs);
    }

    public static int checkSumMB(String value) {
        int cs = DataValidator.mod11(value);
        return cs > 9 ? 0 : cs;
    }

    private static boolean isDateValid(String value, String pattern) {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        sdf.setLenient(false);
        try {
            sdf.parse(value);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }

    private static int mod11(String value) {
        int cs = 0;
        int multiplier = 2;
        for (int i = value.length() - 1; i >= 0; --i) {
            cs += DataValidator.parseInt(value.charAt(i)) * multiplier;
            multiplier = multiplier == 7 ? 2 : multiplier + 1;
        }
        return 11 - cs % 11;
    }

    private static int parseInt(char value) {
        return value - 48;
    }

    public static void main(String[] args) {
        System.out.println(DataValidator.isPIBValid("107170517"));
        System.out.println(DataValidator.isMBValid("61930507"));
        System.out.println(DataValidator.isJMBGValid("0802982720086"));
        System.out.println(DataValidator.isGTINValid("8600102663831"));
    }
}

