/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pos.util;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.WordUtils;

public class Formatter {
    private int rowLength;
    private DecimalFormat priceFormat;
    private DecimalFormat qtyFormat;
    private DecimalFormat amountFormat;
    private DateTimeFormatter dateFormat;

    public Formatter(int rowLength, DecimalFormat priceFormat, DecimalFormat qtyFormat, DecimalFormat amountFormat, DateTimeFormatter dateFormat) {
        this.rowLength = rowLength;
        this.priceFormat = priceFormat;
        this.qtyFormat = qtyFormat;
        this.amountFormat = amountFormat;
        this.dateFormat = dateFormat;
    }

    public String header(String text) {
        if (text == null) {
            return null;
        }
        return StringUtils.center((String)(" " + text + " "), (int)this.rowLength, (String)"=");
    }

    public String title(String text) {
        if (text == null) {
            return null;
        }
        return this.title(text, "=");
    }

    public String title(String text, String padChar) {
        if (text == null) {
            return null;
        }
        return StringUtils.center((String)(" " + text + " "), (int)this.rowLength, (String)padChar);
    }

    public String emp(String text) {
        if (text == null) {
            return null;
        }
        String result = StringUtils.capitalize((String)text).chars().mapToObj(e -> String.valueOf((char)e)).collect(Collectors.joining(" "));
        return result;
    }

    public String center(String text) {
        if (text == null) {
            return null;
        }
        String wrap = WordUtils.wrap((String)text, (int)this.rowLength, null, (boolean)true);
        String result = Arrays.asList(wrap.split("\r\n")).stream().map(row -> StringUtils.center((String)row, (int)this.rowLength)).collect(Collectors.joining("\r\n"));
        return result;
    }

    public String right(String text) {
        return this.right(text, this.rowLength);
    }

    public String right(String text, int length) {
        if (text == null) {
            return null;
        }
        return StringUtils.leftPad((String)text, (int)length);
    }

    public String right(BigDecimal number) {
        return this.right(this.number(number));
    }

    public String left(String text, int length) {
        if (text == null) {
            return null;
        }
        return StringUtils.rightPad((String)text, (int)length);
    }

    public String left(String text) {
        return this.left(text, this.rowLength);
    }

    public String number(BigDecimal number) {
        if (number == null) {
            return null;
        }
        return new DecimalFormat("###,##0.00").format(number.doubleValue());
    }

    public String integer(int number) {
        return String.valueOf(number);
    }

    public BigDecimal asnumber(String number) {
        if (number == null) {
            return null;
        }
        return new BigDecimal(number);
    }

    public String price(BigDecimal number) {
        if (number == null) {
            return null;
        }
        return this.priceFormat.format(number.doubleValue());
    }

    public String qty(BigDecimal number) {
        if (number == null) {
            return null;
        }
        return this.qtyFormat.format(number);
    }

    public String amount(BigDecimal number) {
        if (number == null) {
            return null;
        }
        return this.amountFormat.format(number.doubleValue());
    }

    public String rate(BigDecimal rate) {
        if (rate == null) {
            return null;
        }
        return rate.toString() + "%";
    }

    public String dateTime(LocalDateTime dateTime) {
        if (dateTime == null) {
            return null;
        }
        return dateTime.format(this.dateFormat);
    }

    public String date(LocalDate date) {
        if (date == null) {
            return null;
        }
        return date.format(DateTimeFormatter.ofPattern("dd.MM.yyyy."));
    }

    public String list(List<?> list) {
        if (list == null) {
            return null;
        }
        return "(" + list.stream().map(String::valueOf).collect(Collectors.joining(",")) + ")";
    }

    public String separator(String separatorChar) {
        return StringUtils.center((String)"", (int)this.rowLength, (String)separatorChar);
    }

    public String layout(String left, String right, int length) {
        if (left.length() + right.length() < length) {
            return left + this.right(right, length - left.length());
        }
        Object text = "";
        String[] lines = this.wrap(left + " " + right).split("\r\n");
        for (int i = 0; i < lines.length; ++i) {
            text = (String)text + (String)(i == lines.length - 1 ? this.right(lines[i].trim()) : lines[i] + "\r\n");
        }
        return text;
    }

    public String layout(String left, String right) {
        return this.layout(left, right, this.rowLength);
    }

    public String wrap(String text) {
        if (text == null) {
            return null;
        }
        Object result = "";
        String[] lines = text.split("\r\n|\n");
        for (int j = 0; j < lines.length; ++j) {
            String[] wrap = WordUtils.wrap((String)lines[j], (int)this.rowLength, null, (boolean)true).split("\r\n");
            for (int i = 0; i < wrap.length; ++i) {
                result = (String)result + this.left(wrap[i]);
                result = j == lines.length - 1 && i == wrap.length - 1 ? (String)result : (String)result + "\r\n";
            }
        }
        return result;
    }
}

