/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.xcelerate.core.fxml;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.Parent;
import org.springframework.util.Assert;
import rs.tetrabyte.xcelerate.core.fxml.FXMLTask;
import rs.tetrabyte.xcelerate.core.fxml.FXMLTaskFactory;
import rs.tetrabyte.xcelerate.core.fxml.FXMLValuePair;
import rs.tetrabyte.xcelerate.core.fxml.Output;
import rs.tetrabyte.xcelerate.core.fxml.PostLoad;
import rs.tetrabyte.xcelerate.core.fxml.Wrapper;
import rs.tetrabyte.xcelerate.core.fxml.annotation.ScopeType;
import rs.tetrabyte.xcelerate.core.task.AbstractTask;
import rs.tetrabyte.xcelerate.core.task.Job;
import rs.tetrabyte.xcelerate.core.task.Task;
import rs.tetrabyte.xcelerate.core.task.TaskFactory;
import rs.tetrabyte.xcelerate.core.task.UIAccessor;

public abstract class FXMLController
implements Initializable,
PostLoad {
    private Output parentOutput = new Output();
    private FXMLTaskFactory fxmlTaskFactory;
    private FXMLJob job;
    private Node view;
    private TaskFactory taskFactory;

    public void setTaskFactory(TaskFactory taskFactory) {
        this.taskFactory = taskFactory;
    }

    void setFxmlTaskFactory(FXMLTaskFactory taskFactory) {
        this.fxmlTaskFactory = taskFactory;
    }

    void setParentOutput(Output parentOutput) {
        this.parentOutput = parentOutput;
    }

    public void initialize(URL location, ResourceBundle resources) {
    }

    @Override
    public void postLoad() {
    }

    protected <V> TaskRunner<V> doAsync(Callable<V> supplier) {
        Task<V> task = this.taskFactory.createTask(supplier);
        if (this.getRootNode() instanceof UIAccessor) {
            task.uiAccessor((UIAccessor)this.getRootNode());
        }
        return new TaskRunner<V>(task);
    }

    protected <T extends Node> void createView(String fxml, Class<? extends FXMLController> controllerClass, Consumer<T> consumer) {
        this.loadView(fxml, controllerClass).getView(consumer);
    }

    protected <T extends Node> void createView(Class<? extends FXMLController> controllerClass, Consumer<T> consumer) {
        this.loadView(controllerClass).getView(consumer);
    }

    protected <T extends Node> FXMLViewLoader<T> loadView(Class<? extends FXMLController> controllerClass) {
        return new FXMLViewLoader(this, this.fxmlTaskFactory.createTask(controllerClass).parent(this));
    }

    protected <T extends Node> FXMLViewLoader<T> loadView(String fxml, Class<? extends FXMLController> controllerClass) {
        return new FXMLViewLoader(this, this.fxmlTaskFactory.createTask(fxml, controllerClass).parent(this));
    }

    protected <T extends Node> T getRootNode(Class<T> type) {
        Assert.notNull((Object)this.view, (String)"Can't access the root node because it hasn't been set yet.");
        return (T)((Node)type.cast(this.view));
    }

    protected <T extends Node> T getRootNode() {
        return (T)this.getRootNode(Node.class);
    }

    void setRootNode(Node view) {
        this.view = view;
    }

    protected <T extends Node> T getNodeById(String id, Class<T> type) {
        return (T)((Node)type.cast(this.view.lookup("#" + id)));
    }

    protected Node getNodeById(String id) {
        return this.getNodeById(id, Node.class);
    }

    protected <T extends Node> Optional<T> findNodeById(String id, Class<T> type) {
        Node node = this.getRootNode(Node.class).lookup("#" + id);
        return Optional.ofNullable((Node)type.cast(node));
    }

    protected Optional<Node> findNodeById(String id) {
        return this.findNodeById(id, Node.class);
    }

    public static class TaskRunner<V> {
        private Task<V> task;

        public TaskRunner(Task<V> task) {
            this.task = task;
        }

        public TaskRunner<V> onFailed(Consumer<Throwable> ex) {
            this.task.ifFailed(ex);
            return this;
        }

        public void whenDone(Consumer<V> done) {
            ((AbstractTask)((Object)this.task.whenDone(done))).execute();
        }
    }

    public static class FXMLViewLoader<V extends Node> {
        private FXMLTask<V, FXMLController> task;
        private FXMLController parentController;

        public FXMLViewLoader(FXMLController controller, FXMLTask<V, FXMLController> task) {
            this.task = task;
            this.parentController = controller;
        }

        public void getView(Consumer<V> view) {
            if (view == null) {
                throw new IllegalArgumentException("Supplied consumer function is null");
            }
            ((AbstractTask)((Object)this.task.parentOutput(this.parentController.parentOutput).whenDone(pair -> {
                ((FXMLController)pair.getController()).parentOutput.and(this.parentController);
                view.accept(pair.getView());
            }))).execute();
        }

        public void get(Consumer<FXMLValuePair<V, FXMLController>> fxml) {
            if (fxml == null) {
                throw new IllegalArgumentException("Supplied consumer function is null");
            }
            ((AbstractTask)((Object)this.task.parentOutput(this.parentController.parentOutput).whenDone(pair -> {
                ((FXMLController)pair.getController()).parentOutput.and(this.parentController);
                fxml.accept((FXMLValuePair<V, FXMLController>)pair);
            }))).execute();
        }

        public FXMLJob prepare(Consumer<V> view) {
            this.task.parentOutput(this.parentController.parentOutput).whenDone(pair -> {
                ((FXMLController)pair.getController()).parentOutput.and(this.parentController);
                view.accept(pair.getView());
            });
            if (this.parentController.job == null) {
                this.parentController.job = new FXMLJob(this.parentController);
            }
            this.parentController.job.loaders.add(this);
            return this.parentController.job;
        }

        public FXMLViewLoader<V> output(Object ... vals) {
            this.task.output(vals);
            return this;
        }

        public FXMLViewLoader<V> output(String name, Object value, ScopeType scope) {
            this.task.output(Output.value(name, value, scope));
            return this;
        }

        public FXMLViewLoader<V> output(String name, Object value) {
            this.task.output(Output.value(name, value));
            return this;
        }

        public FXMLViewLoader<V> output(Output output) {
            this.task.output(output);
            return this;
        }

        public <T extends Node> FXMLViewLoader<T> ofType(Class<T> type) {
            return this;
        }

        public <W extends Parent> FXMLViewLoader<W> wrap(Wrapper<W> node) {
            this.task.wrap(node);
            return this;
        }
    }

    public static class FXMLJob {
        private List<FXMLViewLoader<?>> loaders = new ArrayList();
        private FXMLController controller;
        private Runnable whenDone;

        public FXMLJob(FXMLController controller) {
            this.controller = controller;
        }

        public <T extends Node> FXMLViewLoader<T> loadView(Class<? extends FXMLController> controllerClass) {
            FXMLViewLoader loader = this.controller.loadView(controllerClass);
            this.loaders.add(loader);
            return loader;
        }

        public <T extends Node> FXMLViewLoader<T> loadView(String fxml, Class<? extends FXMLController> controllerClass) {
            FXMLViewLoader loader = this.controller.loadView(fxml, controllerClass);
            this.loaders.add(loader);
            return loader;
        }

        public FXMLJob whenDone(Runnable run) {
            this.whenDone = run;
            return this;
        }

        public void load() {
            Job job = this.loaders.get((int)0).task.join(this.loaders.get((int)1).task);
            if (this.loaders.size() > 2) {
                for (int i = 2; i < this.loaders.size(); ++i) {
                    job = job.join(this.loaders.get((int)i).task);
                }
            }
            job.whenDone(this.whenDone).execute();
        }
    }
}

