/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.xcelerate.core.fxml;

import javafx.scene.Node;
import rs.tetrabyte.xcelerate.core.fxml.FXMLController;
import rs.tetrabyte.xcelerate.core.fxml.FXMLControllerFactory;
import rs.tetrabyte.xcelerate.core.fxml.FXMLLoaderFactory;
import rs.tetrabyte.xcelerate.core.fxml.FXMLTask;
import rs.tetrabyte.xcelerate.core.task.ExceptionHandler;
import rs.tetrabyte.xcelerate.core.task.TaskFactory;
import rs.tetrabyte.xcelerate.core.task.UIAccessor;

public class FXMLTaskFactory {
    private FXMLLoaderFactory loaderFactory;
    private ExceptionHandler errorHandler;
    private UIAccessor uiAcessor;
    private FXMLControllerFactory fxmlControllerFactory;

    public FXMLTaskFactory(FXMLLoaderFactory loaderFactory, ExceptionHandler errorHandler, UIAccessor uiAcessor, TaskFactory taskFactory) {
        this.loaderFactory = loaderFactory;
        this.errorHandler = errorHandler;
        this.uiAcessor = uiAcessor;
        this.fxmlControllerFactory = new FXMLControllerFactory(loaderFactory.getControllerFactory(), this, taskFactory);
    }

    public <V extends Node, C> FXMLTask<V, C> createTask(String fxml, Class<C> controllerClass) {
        if (controllerClass.isAssignableFrom(FXMLController.class)) {
            return new FXMLTask(fxml, controllerClass, this.loaderFactory, this.fxmlControllerFactory, this.errorHandler, this.uiAcessor);
        }
        return new FXMLTask(fxml, controllerClass, this.loaderFactory, null, this.errorHandler, this.uiAcessor);
    }

    public <V extends Node, C> FXMLTask<V, C> createTask(Class<C> controllerClass) {
        if (FXMLController.class.isAssignableFrom(controllerClass)) {
            return new FXMLTask(null, controllerClass, this.loaderFactory, this.fxmlControllerFactory, this.errorHandler, this.uiAcessor);
        }
        return new FXMLTask(null, controllerClass, this.loaderFactory, null, this.errorHandler, this.uiAcessor);
    }
}

