/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.xcelerate.core.fxml;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import rs.tetrabyte.xcelerate.core.fxml.ControllerInputException;
import rs.tetrabyte.xcelerate.core.fxml.annotation.Input;
import rs.tetrabyte.xcelerate.core.fxml.annotation.ScopeType;

public class Output {
    private Set<Value> values = new HashSet<Value>();

    public static Output values(Object ... vals) {
        Output out = new Output();
        for (int i = 0; i < vals.length; ++i) {
            out.and(null, vals[i]);
        }
        return out;
    }

    public static Output value(String name, Object value, ScopeType scope) {
        return new Output().and(name, value, scope);
    }

    public static Output value(String name, Object value) {
        return new Output().and(name, value);
    }

    public Output and(String name, Object value, ScopeType scope) {
        this.values.add(new Value(name, value, scope));
        return this;
    }

    public Output and(String name, Object value) {
        this.values.add(new Value(name, value));
        return this;
    }

    public Output and(Output out) {
        if (out != null) {
            out.values.forEach(v -> this.and(v.name, v.value, v.scope));
        }
        return this;
    }

    public Output andParent(Output out) {
        if (out != null) {
            out.values.stream().filter(v -> v.scope == ScopeType.FULL).forEach(v -> this.and(v.name, v.value, v.scope));
        }
        return this;
    }

    public Output and(Object controller) {
        if (controller != null) {
            List<Field> fields = this.getAllFields(controller);
            for (Field field : fields) {
                rs.tetrabyte.xcelerate.core.fxml.annotation.Output ann = field.getAnnotation(rs.tetrabyte.xcelerate.core.fxml.annotation.Output.class);
                if (ann == null) continue;
                try {
                    field.setAccessible(true);
                    String alias = ann.value();
                    ScopeType scope = ann.scope();
                    if (!"".equals(alias)) {
                        this.and(alias, field.get(controller), scope);
                    } else {
                        this.and(field.getName(), field.get(controller), scope);
                    }
                    field.setAccessible(false);
                }
                catch (IllegalAccessException | IllegalArgumentException exception) {}
            }
        }
        return this;
    }

    public void inject(Object controller) {
        Assert.notNull((Object)controller, (String)"Controller must not be null");
        List<Field> fields = this.getAllFields(controller);
        HashSet values = new HashSet();
        this.values.forEach(values::add);
        Value found = null;
        for (Field field : fields) {
            if (!field.isAnnotationPresent(Input.class)) continue;
            String inputAlias = field.getAnnotation(Input.class).value();
            for (Value val : values) {
                if (StringUtils.isEmpty((Object)val.name) && StringUtils.isEmpty((Object)inputAlias)) continue;
                if (inputAlias.equals(val.name)) {
                    this.setFieldValue(field, val.value, controller);
                    found = val;
                    break;
                }
                if (!field.getName().equals(val.name)) continue;
                this.setFieldValue(field, val.value, controller);
                found = val;
                break;
            }
            if (found != null) {
                values.remove(found);
            } else {
                for (Value val : values) {
                    if (!StringUtils.isEmpty((Object)val.name) || !StringUtils.isEmpty((Object)inputAlias) || val.value == null || !field.getType().isAssignableFrom(val.value.getClass())) continue;
                    this.setFieldValue(field, val.value, controller);
                    found = val;
                    break;
                }
                if (found != null) {
                    values.remove(found);
                }
            }
            found = null;
        }
    }

    public Object[] getMethodParams(Method method) {
        if (method.getParameterCount() == 0) {
            return new Object[0];
        }
        Object[] paramValues = new Object[method.getParameterCount()];
        HashSet values = new HashSet();
        this.values.forEach(values::add);
        String inputAlias = "";
        Value found = null;
        for (int i = 0; i < method.getParameterCount(); ++i) {
            Parameter param = method.getParameters()[i];
            if (param.getAnnotation(Input.class) != null) {
                inputAlias = param.getAnnotation(Input.class).value();
                for (Value val : values) {
                    if (!inputAlias.equals(val.name)) continue;
                    paramValues[i] = val.value;
                    found = val;
                    break;
                }
            }
            if (found != null) {
                values.remove(found);
            } else {
                for (Value val : values) {
                    if (val.value == null || !param.getType().isAssignableFrom(val.value.getClass())) continue;
                    paramValues[i] = val.value;
                    found = val;
                    break;
                }
                if (found != null) {
                    values.remove(found);
                }
            }
            if (found == null) {
                throw new IllegalArgumentException(String.format("Can't find input parameter [name = %s, type = %s]", inputAlias, param.getType().getSimpleName()));
            }
            found = null;
        }
        return paramValues;
    }

    private <T> List<Field> getAllFields(T t) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> clazz = t.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
        }
        return fields;
    }

    private void setFieldValue(Field field, Object value, Object target) {
        try {
            field.setAccessible(true);
            field.set(target, value);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new ControllerInputException(field.getName(), target.getClass(), e);
        }
        finally {
            field.setAccessible(false);
        }
    }

    private static class Value {
        String name;
        Object value;
        ScopeType scope;

        public Value(String name, Object value, ScopeType scope) {
            this.name = name;
            this.value = value;
            this.scope = scope;
        }

        public Value(String name, Object value) {
            this(name, value, ScopeType.CHILD);
        }
    }
}

