/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.xcelerate.core.task;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javafx.concurrent.WorkerStateEvent;
import rs.tetrabyte.xcelerate.core.task.AbstractTask;
import rs.tetrabyte.xcelerate.core.task.UIAccessor;

public class Job {
    private List<AbstractTask<?>> tasks = new ArrayList();
    private UIAccessor uiAccessor;
    private boolean lockUI;
    private Runnable whenDone;

    public Job(UIAccessor uiAccessor) {
        this.uiAccessor = uiAccessor;
        this.lockUI = true;
    }

    public Job join(AbstractTask<?> ... task) {
        for (int i = 0; i < task.length; ++i) {
            this.tasks.add(task[i]);
        }
        return this;
    }

    public Job lockUI(boolean value) {
        this.lockUI = value;
        return this;
    }

    public void execute() {
        if (this.tasks.size() > 0) {
            this.execute(this.tasks.iterator());
        }
    }

    public Job whenDone(Runnable runnable) {
        this.whenDone = runnable;
        return this;
    }

    private void execute(Iterator<AbstractTask<?>> i) {
        AbstractTask<?> task = i.next();
        task.addEventFilter(WorkerStateEvent.WORKER_STATE_SUCCEEDED, e -> {
            if (i.hasNext()) {
                if (this.lockUI) {
                    this.uiAccessor.lockUI();
                }
                this.execute(i);
            } else {
                if (this.lockUI) {
                    this.uiAccessor.unlockUI();
                }
                if (this.whenDone != null) {
                    this.whenDone.run();
                }
            }
        });
        task.addEventFilter(WorkerStateEvent.WORKER_STATE_FAILED, e -> {
            if (this.lockUI) {
                this.uiAccessor.unlockUI();
            }
        });
        Thread t = new Thread((Runnable)task.lockUI(false));
        t.setDaemon(false);
        t.start();
    }
}

