/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.ddl;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.jumpmind.symmetric.ddl.DatabaseOperationException;

public class PlatformUtils {
    public static final String JDBC_DRIVER_DATADIRECT_DB2 = "com.ddtek.jdbc.db2.DB2Driver";
    public static final String JDBC_DRIVER_DATADIRECT_SQLSERVER = "com.ddtek.jdbc.sqlserver.SQLServerDriver";
    public static final String JDBC_DRIVER_DATADIRECT_ORACLE = "com.ddtek.jdbc.oracle.OracleDriver";
    public static final String JDBC_DRIVER_DATADIRECT_SYBASE = "com.ddtek.jdbc.sybase.SybaseDriver";
    public static final String JDBC_DRIVER_INET_DB2 = "com.inet.drda.DRDADriver";
    public static final String JDBC_DRIVER_INET_ORACLE = "com.inet.ora.OraDriver";
    public static final String JDBC_DRIVER_INET_SQLSERVER = "com.inet.tds.TdsDriver";
    public static final String JDBC_DRIVER_INET_SYBASE = "com.inet.syb.SybDriver";
    public static final String JDBC_DRIVER_INET_POOLED = "com.inet.pool.PoolDriver";
    public static final String JDBC_DRIVER_JSQLCONNECT_SQLSERVER = "com.jnetdirect.jsql.JSQLDriver";
    public static final String JDBC_DRIVER_JTDS = "net.sourceforge.jtds.jdbc.Driver";
    public static final String JDBC_SUBPROTOCOL_DATADIRECT_DB2 = "datadirect:db2";
    public static final String JDBC_SUBPROTOCOL_DATADIRECT_SQLSERVER = "datadirect:sqlserver";
    public static final String JDBC_SUBPROTOCOL_DATADIRECT_ORACLE = "datadirect:oracle";
    public static final String JDBC_SUBPROTOCOL_DATADIRECT_SYBASE = "datadirect:sybase";
    public static final String JDBC_SUBPROTOCOL_INET_DB2 = "inetdb2";
    public static final String JDBC_SUBPROTOCOL_INET_ORACLE = "inetora";
    public static final String JDBC_SUBPROTOCOL_INET_SQLSERVER = "inetdae";
    public static final String JDBC_SUBPROTOCOL_INET_SQLSERVER6 = "inetdae6";
    public static final String JDBC_SUBPROTOCOL_INET_SQLSERVER7 = "inetdae7";
    public static final String JDBC_SUBPROTOCOL_INET_SQLSERVER7A = "inetdae7a";
    public static final String JDBC_SUBPROTOCOL_INET_SQLSERVER_POOLED_1 = "inetpool:inetdae";
    public static final String JDBC_SUBPROTOCOL_INET_SQLSERVER6_POOLED_1 = "inetpool:inetdae6";
    public static final String JDBC_SUBPROTOCOL_INET_SQLSERVER7_POOLED_1 = "inetpool:inetdae7";
    public static final String JDBC_SUBPROTOCOL_INET_SQLSERVER7A_POOLED_1 = "inetpool:inetdae7a";
    public static final String JDBC_SUBPROTOCOL_INET_SQLSERVER_POOLED_2 = "inetpool:jdbc:inetdae";
    public static final String JDBC_SUBPROTOCOL_INET_SQLSERVER6_POOLED_2 = "inetpool:jdbc:inetdae6";
    public static final String JDBC_SUBPROTOCOL_INET_SQLSERVER7_POOLED_2 = "inetpool:jdbc:inetdae7";
    public static final String JDBC_SUBPROTOCOL_INET_SQLSERVER7A_POOLED_2 = "inetpool:jdbc:inetdae7a";
    public static final String JDBC_SUBPROTOCOL_INET_SYBASE = "inetsyb";
    public static final String JDBC_SUBPROTOCOL_INET_SYBASE_POOLED_1 = "inetpool:inetsyb";
    public static final String JDBC_SUBPROTOCOL_INET_SYBASE_POOLED_2 = "inetpool:jdbc:inetsyb";
    public static final String JDBC_SUBPROTOCOL_JSQLCONNECT_SQLSERVER = "JSQLConnect";
    public static final String JDBC_SUBPROTOCOL_JTDS_SQLSERVER = "jtds:sqlserver";
    public static final String JDBC_SUBPROTOCOL_JTDS_SYBASE = "jtds:sybase";
    private static HashMap<String, String> jdbcSubProtocolToPlatform = new HashMap();
    private static HashMap<String, String> jdbcDriverToPlatform = new HashMap();

    private PlatformUtils() {
    }

    public static String determineDatabaseType(DataSource dataSource) throws DatabaseOperationException {
        Connection connection = null;
        try {
            connection = dataSource.getConnection();
            DatabaseMetaData metaData = connection.getMetaData();
            String string = PlatformUtils.determineDatabaseType(metaData.getDriverName(), metaData.getURL());
            return string;
        }
        catch (SQLException ex) {
            throw new DatabaseOperationException("Error while reading the database metadata: " + ex.getMessage(), ex);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException ex) {}
            }
        }
    }

    public static String getDatabaseProductVersion(DataSource dataSource) {
        Connection connection = null;
        try {
            connection = dataSource.getConnection();
            DatabaseMetaData metaData = connection.getMetaData();
            String string = metaData.getDatabaseProductVersion();
            return string;
        }
        catch (SQLException ex) {
            throw new DatabaseOperationException("Error while reading the database metadata: " + ex.getMessage(), ex);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException ex) {}
            }
        }
    }

    public static int getDatabaseMajorVersion(DataSource dataSource) {
        Connection connection = null;
        try {
            connection = dataSource.getConnection();
            DatabaseMetaData metaData = connection.getMetaData();
            int n = metaData.getDatabaseMajorVersion();
            return n;
        }
        catch (SQLException ex) {
            throw new DatabaseOperationException("Error while reading the database metadata: " + ex.getMessage(), ex);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException ex) {}
            }
        }
    }

    public static int getDatabaseMinorVersion(DataSource dataSource) {
        Connection connection = null;
        try {
            connection = dataSource.getConnection();
            DatabaseMetaData metaData = connection.getMetaData();
            int n = metaData.getDatabaseMinorVersion();
            return n;
        }
        catch (SQLException ex) {
            throw new DatabaseOperationException("Error while reading the database metadata: " + ex.getMessage(), ex);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException ex) {}
            }
        }
    }

    public static String determineDatabaseNameVersion(DataSource dataSource) throws DatabaseOperationException {
        Connection connection = null;
        try {
            connection = dataSource.getConnection();
            DatabaseMetaData metaData = connection.getMetaData();
            String productName = metaData.getDatabaseProductName();
            int majorVersion = metaData.getDatabaseMajorVersion();
            if (productName.equalsIgnoreCase("PostgreSql") && PlatformUtils.isGreenplumDatabase(connection)) {
                productName = "Greenplum";
                majorVersion = PlatformUtils.getGreenplumVersion(connection);
            }
            String productString = productName;
            if (majorVersion > 0) {
                productString = productString + majorVersion;
            }
            String string = productString;
            return string;
        }
        catch (SQLException ex) {
            throw new DatabaseOperationException("Error while reading the database metadata: " + ex.getMessage(), ex);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException ex) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isGreenplumDatabase(Connection connection) {
        Statement stmt = null;
        ResultSet rs = null;
        String productName = null;
        boolean isGreenplum = false;
        try {
            stmt = connection.createStatement();
            rs = stmt.executeQuery("select gpname from gp_id");
            while (rs.next()) {
                productName = rs.getString(1);
            }
            if (productName != null && productName.equalsIgnoreCase("Greenplum")) {
                isGreenplum = true;
            }
        }
        catch (SQLException ex) {
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException ex) {}
        }
        return isGreenplum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getGreenplumVersion(Connection connection) {
        Statement stmt = null;
        ResultSet rs = null;
        String versionName = null;
        int productVersion = 0;
        try {
            stmt = connection.createStatement();
            rs = stmt.executeQuery("select productversion from gp_version_at_initdb");
            while (rs.next()) {
                versionName = rs.getString(1);
            }
            if (versionName.indexOf(46) != -1) {
                versionName = versionName.substring(0, versionName.indexOf(46));
            }
            try {
                productVersion = Integer.parseInt(versionName);
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        catch (SQLException ex) {
        }
        finally {
            try {
                rs.close();
                stmt.close();
            }
            catch (SQLException ex) {}
        }
        return productVersion;
    }

    public static String determineDatabaseType(String driverName, String jdbcConnectionUrl) {
        if (jdbcDriverToPlatform.containsKey(driverName)) {
            return jdbcDriverToPlatform.get(driverName);
        }
        if (jdbcConnectionUrl == null) {
            return null;
        }
        for (Map.Entry<String, String> entry : jdbcSubProtocolToPlatform.entrySet()) {
            String curSubProtocol = "jdbc:" + entry.getKey() + ":";
            if (!jdbcConnectionUrl.startsWith(curSubProtocol)) continue;
            return entry.getValue();
        }
        return null;
    }

    static {
        jdbcSubProtocolToPlatform.put("db2j:net", "Cloudscape");
        jdbcSubProtocolToPlatform.put("cloudscape:net", "Cloudscape");
        jdbcSubProtocolToPlatform.put("db2", "DB2");
        jdbcSubProtocolToPlatform.put("db2os390", "DB2");
        jdbcSubProtocolToPlatform.put("db2os390sqlj", "DB2");
        jdbcSubProtocolToPlatform.put("as400", "DB2");
        jdbcSubProtocolToPlatform.put(JDBC_SUBPROTOCOL_DATADIRECT_DB2, "DB2");
        jdbcSubProtocolToPlatform.put(JDBC_SUBPROTOCOL_INET_DB2, "DB2");
        jdbcSubProtocolToPlatform.put("derby", "Derby");
        jdbcSubProtocolToPlatform.put("firebirdsql", "Firebird");
        jdbcSubProtocolToPlatform.put("hsqldb", "HsqlDb");
        jdbcSubProtocolToPlatform.put("interbase", "Interbase");
        jdbcSubProtocolToPlatform.put("microsoft:sqlserver", "MsSql");
        jdbcSubProtocolToPlatform.put("sqlserver", "MsSql");
        jdbcSubProtocolToPlatform.put("sqljdbc", "MsSql");
        jdbcSubProtocolToPlatform.put(JDBC_SUBPROTOCOL_DATADIRECT_SQLSERVER, "MsSql");
        jdbcSubProtocolToPlatform.put(JDBC_SUBPROTOCOL_INET_SQLSERVER, "MsSql");
        jdbcSubProtocolToPlatform.put(JDBC_SUBPROTOCOL_INET_SQLSERVER6, "MsSql");
        jdbcSubProtocolToPlatform.put(JDBC_SUBPROTOCOL_INET_SQLSERVER7, "MsSql");
        jdbcSubProtocolToPlatform.put(JDBC_SUBPROTOCOL_INET_SQLSERVER7A, "MsSql");
        jdbcSubProtocolToPlatform.put(JDBC_SUBPROTOCOL_INET_SQLSERVER_POOLED_1, "MsSql");
        jdbcSubProtocolToPlatform.put(JDBC_SUBPROTOCOL_INET_SQLSERVER6_POOLED_1, "MsSql");
        jdbcSubProtocolToPlatform.put(JDBC_SUBPROTOCOL_INET_SQLSERVER7_POOLED_1, "MsSql");
        jdbcSubProtocolToPlatform.put(JDBC_SUBPROTOCOL_INET_SQLSERVER7A_POOLED_1, "MsSql");
        jdbcSubProtocolToPlatform.put(JDBC_SUBPROTOCOL_INET_SQLSERVER_POOLED_2, "MsSql");
        jdbcSubProtocolToPlatform.put(JDBC_SUBPROTOCOL_INET_SQLSERVER6_POOLED_2, "MsSql");
        jdbcSubProtocolToPlatform.put(JDBC_SUBPROTOCOL_INET_SQLSERVER7_POOLED_2, "MsSql");
        jdbcSubProtocolToPlatform.put(JDBC_SUBPROTOCOL_INET_SQLSERVER7A_POOLED_2, "MsSql");
        jdbcSubProtocolToPlatform.put(JDBC_SUBPROTOCOL_JSQLCONNECT_SQLSERVER, "MsSql");
        jdbcSubProtocolToPlatform.put(JDBC_SUBPROTOCOL_JTDS_SQLSERVER, "MsSql");
        jdbcSubProtocolToPlatform.put("mysql", "MySQL");
        jdbcSubProtocolToPlatform.put("oracle:thin", "Oracle");
        jdbcSubProtocolToPlatform.put("oracle:oci8", "Oracle");
        jdbcSubProtocolToPlatform.put("oracle:dnldthin", "Oracle");
        jdbcSubProtocolToPlatform.put(JDBC_SUBPROTOCOL_DATADIRECT_ORACLE, "Oracle");
        jdbcSubProtocolToPlatform.put(JDBC_SUBPROTOCOL_INET_ORACLE, "Oracle");
        jdbcSubProtocolToPlatform.put("postgresql", "PostgreSql");
        jdbcSubProtocolToPlatform.put("sybase:Tds", "Sybase");
        jdbcSubProtocolToPlatform.put(JDBC_SUBPROTOCOL_DATADIRECT_SYBASE, "Sybase");
        jdbcSubProtocolToPlatform.put(JDBC_SUBPROTOCOL_INET_SYBASE, "Sybase");
        jdbcSubProtocolToPlatform.put(JDBC_SUBPROTOCOL_INET_SYBASE_POOLED_1, "Sybase");
        jdbcSubProtocolToPlatform.put(JDBC_SUBPROTOCOL_INET_SYBASE_POOLED_2, "Sybase");
        jdbcSubProtocolToPlatform.put(JDBC_SUBPROTOCOL_JTDS_SYBASE, "Sybase");
        jdbcDriverToPlatform.put("com.ibm.db2.jcc.DB2Driver", "DB2");
        jdbcDriverToPlatform.put("COM.ibm.db2.jdbc.app.DB2Driver", "DB2");
        jdbcDriverToPlatform.put("COM.ibm.db2os390.sqlj.jdbc.DB2SQLJDriver", "DB2");
        jdbcDriverToPlatform.put("com.ibm.as400.access.AS400JDBCDriver", "DB2");
        jdbcDriverToPlatform.put(JDBC_DRIVER_DATADIRECT_DB2, "DB2");
        jdbcDriverToPlatform.put(JDBC_DRIVER_INET_DB2, "DB2");
        jdbcDriverToPlatform.put("org.apache.derby.jdbc.EmbeddedDriver", "Derby");
        jdbcDriverToPlatform.put("org.apache.derby.jdbc.ClientDriver", "Derby");
        jdbcDriverToPlatform.put("org.firebirdsql.jdbc.FBDriver", "Firebird");
        jdbcDriverToPlatform.put("org.hsqldb.jdbcDriver", "HsqlDb");
        jdbcDriverToPlatform.put("interbase.interclient.Driver", "Interbase");
        jdbcDriverToPlatform.put("com.microsoft.jdbc.sqlserver.SQLServerDriver", "MsSql");
        jdbcDriverToPlatform.put("com.microsoft.sqlserver.jdbc.SQLServerDriver", "MsSql");
        jdbcDriverToPlatform.put(JDBC_DRIVER_DATADIRECT_SQLSERVER, "MsSql");
        jdbcDriverToPlatform.put(JDBC_DRIVER_INET_SQLSERVER, "MsSql");
        jdbcDriverToPlatform.put(JDBC_DRIVER_JSQLCONNECT_SQLSERVER, "MsSql");
        jdbcDriverToPlatform.put("com.mysql.jdbc.Driver", "MySQL");
        jdbcDriverToPlatform.put("org.gjt.mm.mysql.Driver", "MySQL");
        jdbcDriverToPlatform.put("oracle.jdbc.driver.OracleDriver", "Oracle");
        jdbcDriverToPlatform.put("oracle.jdbc.dnlddriver.OracleDriver", "Oracle");
        jdbcDriverToPlatform.put(JDBC_DRIVER_DATADIRECT_ORACLE, "Oracle");
        jdbcDriverToPlatform.put(JDBC_DRIVER_INET_ORACLE, "Oracle");
        jdbcDriverToPlatform.put("org.postgresql.Driver", "PostgreSql");
        jdbcDriverToPlatform.put("com.sybase.jdbc2.jdbc.SybDriver", "Sybase");
        jdbcDriverToPlatform.put("com.sybase.jdbc.SybDriver", "Sybase");
        jdbcDriverToPlatform.put(JDBC_DRIVER_DATADIRECT_SYBASE, "Sybase");
        jdbcDriverToPlatform.put(JDBC_DRIVER_INET_SYBASE, "Sybase");
    }
}

