/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.ddl.alteration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jumpmind.symmetric.ddl.PlatformInfo;
import org.jumpmind.symmetric.ddl.alteration.AddColumnChange;
import org.jumpmind.symmetric.ddl.alteration.AddForeignKeyChange;
import org.jumpmind.symmetric.ddl.alteration.AddIndexChange;
import org.jumpmind.symmetric.ddl.alteration.AddPrimaryKeyChange;
import org.jumpmind.symmetric.ddl.alteration.AddTableChange;
import org.jumpmind.symmetric.ddl.alteration.ColumnAutoIncrementChange;
import org.jumpmind.symmetric.ddl.alteration.ColumnDataTypeChange;
import org.jumpmind.symmetric.ddl.alteration.ColumnDefaultValueChange;
import org.jumpmind.symmetric.ddl.alteration.ColumnRequiredChange;
import org.jumpmind.symmetric.ddl.alteration.ColumnSizeChange;
import org.jumpmind.symmetric.ddl.alteration.ModelChange;
import org.jumpmind.symmetric.ddl.alteration.PrimaryKeyChange;
import org.jumpmind.symmetric.ddl.alteration.RemoveColumnChange;
import org.jumpmind.symmetric.ddl.alteration.RemoveForeignKeyChange;
import org.jumpmind.symmetric.ddl.alteration.RemoveIndexChange;
import org.jumpmind.symmetric.ddl.alteration.RemovePrimaryKeyChange;
import org.jumpmind.symmetric.ddl.alteration.RemoveTableChange;
import org.jumpmind.symmetric.ddl.alteration.TableChangeImplBase;
import org.jumpmind.symmetric.ddl.model.Column;
import org.jumpmind.symmetric.ddl.model.Database;
import org.jumpmind.symmetric.ddl.model.ForeignKey;
import org.jumpmind.symmetric.ddl.model.Index;
import org.jumpmind.symmetric.ddl.model.Table;

public class ModelComparator {
    private final Log _log = LogFactory.getLog(ModelComparator.class);
    private PlatformInfo _platformInfo;
    private boolean _caseSensitive;

    public ModelComparator(PlatformInfo platformInfo, boolean caseSensitive) {
        this._platformInfo = platformInfo;
        this._caseSensitive = caseSensitive;
    }

    public List compare(Database sourceModel, Database targetModel) {
        int fkIdx;
        int tableIdx;
        ArrayList<ModelChange> changes = new ArrayList<ModelChange>();
        for (tableIdx = 0; tableIdx < targetModel.getTableCount(); ++tableIdx) {
            Table targetTable = targetModel.getTable(tableIdx);
            Table sourceTable = sourceModel.findTable(targetTable.getName(), this._caseSensitive);
            if (sourceTable == null) {
                if (this._log.isDebugEnabled()) {
                    this._log.debug((Object)("Table " + targetTable.getName() + " needs to be added"));
                }
                changes.add(new AddTableChange(targetTable));
                for (fkIdx = 0; fkIdx < targetTable.getForeignKeyCount(); ++fkIdx) {
                    changes.add(new AddForeignKeyChange(targetTable, targetTable.getForeignKey(fkIdx)));
                }
                continue;
            }
            changes.addAll(this.compareTables(sourceModel, sourceTable, targetModel, targetTable));
        }
        for (tableIdx = 0; tableIdx < sourceModel.getTableCount(); ++tableIdx) {
            Table sourceTable = sourceModel.getTable(tableIdx);
            Table targetTable = targetModel.findTable(sourceTable.getName(), this._caseSensitive);
            if (targetTable != null || sourceTable.getName() == null || sourceTable.getName().length() <= 0) continue;
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("Table " + sourceTable.getName() + " needs to be removed"));
            }
            changes.add(new RemoveTableChange(sourceTable));
            for (fkIdx = 0; fkIdx < sourceTable.getForeignKeyCount(); ++fkIdx) {
                changes.add(new RemoveForeignKeyChange(sourceTable, sourceTable.getForeignKey(fkIdx)));
            }
        }
        return changes;
    }

    public List compareTables(Database sourceModel, Table sourceTable, Database targetModel, Table targetTable) {
        AddColumnChange change;
        Column targetColumn;
        int columnIdx;
        int indexIdx;
        int fkIdx;
        ArrayList<TableChangeImplBase> changes = new ArrayList<TableChangeImplBase>();
        for (fkIdx = 0; fkIdx < sourceTable.getForeignKeyCount(); ++fkIdx) {
            ForeignKey sourceFk = sourceTable.getForeignKey(fkIdx);
            ForeignKey targetFk = this.findCorrespondingForeignKey(targetTable, sourceFk);
            if (targetFk != null) continue;
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("Foreign key " + sourceFk + " needs to be removed from table " + sourceTable.getName()));
            }
            changes.add(new RemoveForeignKeyChange(sourceTable, sourceFk));
        }
        for (fkIdx = 0; fkIdx < targetTable.getForeignKeyCount(); ++fkIdx) {
            ForeignKey targetFk = targetTable.getForeignKey(fkIdx);
            ForeignKey sourceFk = this.findCorrespondingForeignKey(sourceTable, targetFk);
            if (sourceFk != null) continue;
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("Foreign key " + targetFk + " needs to be created for table " + sourceTable.getName()));
            }
            changes.add(new AddForeignKeyChange(targetTable, targetFk));
        }
        for (indexIdx = 0; indexIdx < sourceTable.getIndexCount(); ++indexIdx) {
            Index sourceIndex = sourceTable.getIndex(indexIdx);
            Index targetIndex = this.findCorrespondingIndex(targetTable, sourceIndex);
            if (targetIndex != null) continue;
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("Index " + sourceIndex.getName() + " needs to be removed from table " + sourceTable.getName()));
            }
            changes.add(new RemoveIndexChange(sourceTable, sourceIndex));
        }
        for (indexIdx = 0; indexIdx < targetTable.getIndexCount(); ++indexIdx) {
            Index targetIndex = targetTable.getIndex(indexIdx);
            Index sourceIndex = this.findCorrespondingIndex(sourceTable, targetIndex);
            if (sourceIndex != null) continue;
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("Index " + targetIndex.getName() + " needs to be created for table " + sourceTable.getName()));
            }
            changes.add(new AddIndexChange(targetTable, targetIndex));
        }
        HashMap<Column, AddColumnChange> addColumnChanges = new HashMap<Column, AddColumnChange>();
        for (columnIdx = 0; columnIdx < targetTable.getColumnCount(); ++columnIdx) {
            targetColumn = targetTable.getColumn(columnIdx);
            Column sourceColumn = sourceTable.findColumn(targetColumn.getName(), this._caseSensitive);
            if (sourceColumn == null) {
                if (this._log.isDebugEnabled()) {
                    this._log.debug((Object)("Column " + targetColumn.getName() + " needs to be created for table " + sourceTable.getName()));
                }
                AddColumnChange change2 = new AddColumnChange(sourceTable, targetColumn, columnIdx > 0 ? targetTable.getColumn(columnIdx - 1) : null, columnIdx < targetTable.getColumnCount() - 1 ? targetTable.getColumn(columnIdx + 1) : null);
                changes.add(change2);
                addColumnChanges.put(targetColumn, change2);
                continue;
            }
            changes.addAll(this.compareColumns(sourceTable, sourceColumn, targetTable, targetColumn));
        }
        for (columnIdx = targetTable.getColumnCount() - 1; columnIdx >= 0 && (change = (AddColumnChange)addColumnChanges.get(targetColumn = targetTable.getColumn(columnIdx))) != null; --columnIdx) {
            change.setAtEnd(true);
        }
        Column[] sourcePK = sourceTable.getPrimaryKeyColumns();
        Column[] targetPK = targetTable.getPrimaryKeyColumns();
        if (sourcePK.length == 0 && targetPK.length > 0) {
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("A primary key needs to be added to the table " + sourceTable.getName()));
            }
            changes.add(new AddPrimaryKeyChange(targetTable, targetPK));
        } else if (targetPK.length == 0 && sourcePK.length > 0) {
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("The primary key needs to be removed from the table " + sourceTable.getName()));
            }
            changes.add(new RemovePrimaryKeyChange(sourceTable, sourcePK));
        } else if (sourcePK.length > 0 && targetPK.length > 0) {
            boolean changePK = false;
            if (sourcePK.length != targetPK.length) {
                changePK = true;
            } else {
                for (int pkColumnIdx = 0; pkColumnIdx < sourcePK.length && !changePK; ++pkColumnIdx) {
                    if ((!this._caseSensitive || sourcePK[pkColumnIdx].getName().equals(targetPK[pkColumnIdx].getName())) && (this._caseSensitive || sourcePK[pkColumnIdx].getName().equalsIgnoreCase(targetPK[pkColumnIdx].getName()))) continue;
                    changePK = true;
                }
            }
            if (changePK) {
                if (this._log.isDebugEnabled()) {
                    this._log.debug((Object)("The primary key of table " + sourceTable.getName() + " needs to be changed"));
                }
                changes.add(new PrimaryKeyChange(sourceTable, sourcePK, targetPK));
            }
        }
        for (int columnIdx2 = 0; columnIdx2 < sourceTable.getColumnCount(); ++columnIdx2) {
            Column sourceColumn = sourceTable.getColumn(columnIdx2);
            Column targetColumn2 = targetTable.findColumn(sourceColumn.getName(), this._caseSensitive);
            if (targetColumn2 != null) continue;
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("Column " + sourceColumn.getName() + " needs to be removed from table " + sourceTable.getName()));
            }
            changes.add(new RemoveColumnChange(sourceTable, sourceColumn));
        }
        return changes;
    }

    public List compareColumns(Table sourceTable, Column sourceColumn, Table targetTable, Column targetColumn) {
        ArrayList<TableChangeImplBase> changes = new ArrayList<TableChangeImplBase>();
        if (targetColumn.getTypeCode() != sourceColumn.getTypeCode() && this._platformInfo.getTargetJdbcType(targetColumn.getTypeCode()) != sourceColumn.getTypeCode()) {
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("The " + sourceColumn.getName() + " column on the " + sourceTable.getName() + " table changed type codes from " + sourceColumn.getTypeCode() + " to " + targetColumn.getTypeCode()));
            }
            changes.add(new ColumnDataTypeChange(sourceTable, sourceColumn, targetColumn.getTypeCode()));
        }
        boolean sizeMatters = this._platformInfo.hasSize(sourceColumn.getTypeCode());
        boolean scaleMatters = this._platformInfo.hasPrecisionAndScale(sourceColumn.getTypeCode());
        String targetSize = targetColumn.getSize();
        if (targetSize == null) {
            Integer defaultSize = this._platformInfo.getDefaultSize(this._platformInfo.getTargetJdbcType(targetColumn.getTypeCode()));
            targetSize = defaultSize != null ? defaultSize.toString() : "0";
        }
        if (sizeMatters && !StringUtils.equals((String)sourceColumn.getSize(), (String)targetSize)) {
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("The " + sourceColumn.getName() + " column on the " + sourceTable.getName() + " table changed size from (" + sourceColumn.getSizeAsInt() + ") to (" + targetColumn.getSizeAsInt() + ")"));
            }
            changes.add(new ColumnSizeChange(sourceTable, sourceColumn, targetColumn.getSizeAsInt(), targetColumn.getScale()));
        } else if (scaleMatters && (!StringUtils.equals((String)sourceColumn.getSize(), (String)targetSize) || (sourceColumn.getScale() >= 0 || targetColumn.getScale() != 0) && sourceColumn.getScale() != targetColumn.getScale())) {
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("The " + sourceColumn.getName() + " column on the " + sourceTable.getName() + " table changed scale from (" + sourceColumn.getSizeAsInt() + "," + sourceColumn.getScale() + ") to (" + targetColumn.getSizeAsInt() + "," + targetColumn.getScale() + ")"));
            }
            changes.add(new ColumnSizeChange(sourceTable, sourceColumn, targetColumn.getSizeAsInt(), targetColumn.getScale()));
        }
        Object sourceDefaultValue = sourceColumn.getParsedDefaultValue();
        Object targetDefaultValue = targetColumn.getParsedDefaultValue();
        if (sourceDefaultValue == null && targetDefaultValue != null || sourceDefaultValue != null && !sourceDefaultValue.equals(targetDefaultValue)) {
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("The " + sourceColumn.getName() + " column on the " + sourceTable.getName() + " table changed default value from " + sourceColumn.getDefaultValue() + " to " + targetColumn.getDefaultValue()));
            }
            changes.add(new ColumnDefaultValueChange(sourceTable, sourceColumn, targetColumn.getDefaultValue()));
        }
        if (sourceColumn.isRequired() != targetColumn.isRequired()) {
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("The " + sourceColumn.getName() + " column on the " + sourceTable.getName() + " table changed required status from " + sourceColumn.isRequired() + " to " + targetColumn.isRequired()));
            }
            changes.add(new ColumnRequiredChange(sourceTable, sourceColumn));
        }
        if (sourceColumn.isAutoIncrement() != targetColumn.isAutoIncrement()) {
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("The " + sourceColumn.getName() + " column on the " + sourceTable.getName() + " table changed auto increment status from " + sourceColumn.isAutoIncrement() + " to " + targetColumn.isAutoIncrement()));
            }
            changes.add(new ColumnAutoIncrementChange(sourceTable, sourceColumn));
        }
        return changes;
    }

    private ForeignKey findCorrespondingForeignKey(Table table, ForeignKey fk) {
        for (int fkIdx = 0; fkIdx < table.getForeignKeyCount(); ++fkIdx) {
            ForeignKey curFk = table.getForeignKey(fkIdx);
            if ((!this._caseSensitive || !fk.equals(curFk)) && (this._caseSensitive || !fk.equalsIgnoreCase(curFk))) continue;
            return curFk;
        }
        return null;
    }

    private Index findCorrespondingIndex(Table table, Index index) {
        for (int indexIdx = 0; indexIdx < table.getIndexCount(); ++indexIdx) {
            Index curIndex = table.getIndex(indexIdx);
            if ((!this._caseSensitive || !index.equals(curIndex)) && (this._caseSensitive || !index.equalsIgnoreCase(curIndex))) continue;
            return curIndex;
        }
        return null;
    }
}

