/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.ddl.model;

import java.util.ArrayList;
import org.jumpmind.symmetric.ddl.model.Column;
import org.jumpmind.symmetric.ddl.model.Index;
import org.jumpmind.symmetric.ddl.model.IndexColumn;

public abstract class IndexImpBase
implements Index {
    protected String _name;
    protected ArrayList _columns = new ArrayList();

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public int getColumnCount() {
        return this._columns.size();
    }

    public IndexColumn getColumn(int idx) {
        return (IndexColumn)this._columns.get(idx);
    }

    public IndexColumn[] getColumns() {
        return this._columns.toArray(new IndexColumn[this._columns.size()]);
    }

    public boolean hasColumn(Column column) {
        for (int idx = 0; idx < this._columns.size(); ++idx) {
            IndexColumn curColumn = this.getColumn(idx);
            if (!column.equals(curColumn.getColumn())) continue;
            return true;
        }
        return false;
    }

    public void addColumn(IndexColumn column) {
        if (column != null) {
            for (int idx = 0; idx < this._columns.size(); ++idx) {
                IndexColumn curColumn = this.getColumn(idx);
                if (curColumn.getOrdinalPosition() <= column.getOrdinalPosition()) continue;
                this._columns.add(idx, column);
                return;
            }
            this._columns.add(column);
        }
    }

    public void removeColumn(IndexColumn column) {
        this._columns.remove(column);
    }

    public void removeColumn(int idx) {
        this._columns.remove(idx);
    }

    public abstract Object clone() throws CloneNotSupportedException;
}

