/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.ddl.model;

import java.io.Serializable;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.jumpmind.symmetric.ddl.model.Column;
import org.jumpmind.symmetric.ddl.model.ForeignKey;
import org.jumpmind.symmetric.ddl.model.Index;
import org.jumpmind.symmetric.ddl.model.IndexColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Table
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -5541154961302342608L;
    private String catalog = null;
    private String schema = null;
    private String name = null;
    private String description = null;
    private String type = null;
    private ArrayList<Column> columns = new ArrayList();
    private ArrayList<ForeignKey> foreignKeys = new ArrayList();
    private ArrayList<Index> indices = new ArrayList();

    public Table() {
    }

    public Table(String tableName) {
        this.name = tableName;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public Column getColumn(int idx) {
        return this.columns.get(idx);
    }

    public Column[] getColumns() {
        return this.columns.toArray(new Column[this.columns.size()]);
    }

    public void addColumn(Column column) {
        if (column != null) {
            this.columns.add(column);
        }
    }

    public void addColumn(int idx, Column column) {
        if (column != null) {
            this.columns.add(idx, column);
        }
    }

    public void addColumn(Column previousColumn, Column column) {
        if (column != null) {
            if (previousColumn == null) {
                this.columns.add(0, column);
            } else {
                this.columns.add(this.columns.indexOf(previousColumn), column);
            }
        }
    }

    public void addColumns(Collection<Column> columns) {
        Iterator<Column> it = columns.iterator();
        while (it.hasNext()) {
            this.addColumn(it.next());
        }
    }

    public void removeColumn(Column column) {
        if (column != null) {
            this.columns.remove(column);
        }
    }

    public void removeColumn(int idx) {
        this.columns.remove(idx);
    }

    public int getForeignKeyCount() {
        return this.foreignKeys.size();
    }

    public ForeignKey getForeignKey(int idx) {
        return this.foreignKeys.get(idx);
    }

    public ForeignKey[] getForeignKeys() {
        return this.foreignKeys.toArray(new ForeignKey[this.foreignKeys.size()]);
    }

    public void addForeignKey(ForeignKey foreignKey) {
        if (foreignKey != null) {
            this.foreignKeys.add(foreignKey);
        }
    }

    public void addForeignKey(int idx, ForeignKey foreignKey) {
        if (foreignKey != null) {
            this.foreignKeys.add(idx, foreignKey);
        }
    }

    public void addForeignKeys(Collection<ForeignKey> foreignKeys) {
        Iterator<ForeignKey> it = foreignKeys.iterator();
        while (it.hasNext()) {
            this.addForeignKey(it.next());
        }
    }

    public void removeForeignKey(ForeignKey foreignKey) {
        if (foreignKey != null) {
            this.foreignKeys.remove(foreignKey);
        }
    }

    public void removeForeignKey(int idx) {
        this.foreignKeys.remove(idx);
    }

    public int getIndexCount() {
        return this.indices.size();
    }

    public Index getIndex(int idx) {
        return this.indices.get(idx);
    }

    public void addIndex(Index index) {
        if (index != null) {
            this.indices.add(index);
        }
    }

    public void addIndex(int idx, Index index) {
        if (index != null) {
            this.indices.add(idx, index);
        }
    }

    public void addIndices(Collection<Index> indices) {
        Iterator<Index> it = indices.iterator();
        while (it.hasNext()) {
            this.addIndex(it.next());
        }
    }

    public Index[] getIndices() {
        return this.indices.toArray(new Index[this.indices.size()]);
    }

    public Index[] getNonUniqueIndices() {
        if (this.indices != null) {
            ArrayList<Index> nonunique = new ArrayList<Index>();
            for (Index index : this.indices) {
                if (index.isUnique()) continue;
                nonunique.add(index);
            }
            return nonunique.toArray(new Index[nonunique.size()]);
        }
        return new Index[0];
    }

    public Index[] getUniqueIndices() {
        if (this.indices != null) {
            ArrayList<Index> unique = new ArrayList<Index>();
            for (Index index : this.indices) {
                if (!index.isUnique()) continue;
                unique.add(index);
            }
            return unique.toArray(new Index[unique.size()]);
        }
        return new Index[0];
    }

    public void removeIndex(Index index) {
        if (index != null) {
            this.indices.remove(index);
        }
    }

    public void removeIndex(int idx) {
        this.indices.remove(idx);
    }

    public boolean hasPrimaryKey() {
        for (Column column : this.columns) {
            if (!column.isPrimaryKey()) continue;
            return true;
        }
        return false;
    }

    public Column findColumn(String name) {
        return this.findColumn(name, false);
    }

    public Column findColumn(String name, boolean caseSensitive) {
        for (Column column : this.columns) {
            if (!(caseSensitive ? column.getName().equals(name) : column.getName().equalsIgnoreCase(name))) continue;
            return column;
        }
        return null;
    }

    public int getColumnIndex(Column column) {
        int idx = 0;
        Iterator<Column> it = this.columns.iterator();
        while (it.hasNext()) {
            if (column == it.next()) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    public Index findIndex(String name) {
        return this.findIndex(name, false);
    }

    public Index findIndex(String name, boolean caseSensitive) {
        for (int idx = 0; idx < this.getIndexCount(); ++idx) {
            Index index = this.getIndex(idx);
            if (!(caseSensitive ? index.getName().equals(name) : index.getName().equalsIgnoreCase(name))) continue;
            return index;
        }
        return null;
    }

    public ForeignKey findForeignKey(ForeignKey key) {
        for (int idx = 0; idx < this.getForeignKeyCount(); ++idx) {
            ForeignKey fk = this.getForeignKey(idx);
            if (!fk.equals(key)) continue;
            return fk;
        }
        return null;
    }

    public ForeignKey findForeignKey(ForeignKey key, boolean caseSensitive) {
        for (int idx = 0; idx < this.getForeignKeyCount(); ++idx) {
            ForeignKey fk = this.getForeignKey(idx);
            if ((!caseSensitive || !fk.equals(key)) && (caseSensitive || !fk.equalsIgnoreCase(key))) continue;
            return fk;
        }
        return null;
    }

    public ForeignKey getSelfReferencingForeignKey() {
        for (int idx = 0; idx < this.getForeignKeyCount(); ++idx) {
            ForeignKey fk = this.getForeignKey(idx);
            if (!this.equals(fk.getForeignTable())) continue;
            return fk;
        }
        return null;
    }

    public Column[] getPrimaryKeyColumns() {
        if (this.columns != null) {
            ArrayList<Column> selectedColumns = new ArrayList<Column>();
            for (Column column : this.columns) {
                if (!column.isPrimaryKey()) continue;
                selectedColumns.add(column);
            }
            return selectedColumns.toArray(new Column[selectedColumns.size()]);
        }
        return new Column[0];
    }

    public Column[] getAutoIncrementColumns() {
        if (this.columns != null) {
            ArrayList<Column> selectedColumns = new ArrayList<Column>();
            for (Column column : this.columns) {
                if (!column.isAutoIncrement()) continue;
                selectedColumns.add(column);
            }
            return selectedColumns.toArray(new Column[selectedColumns.size()]);
        }
        return new Column[0];
    }

    public void sortForeignKeys(final boolean caseSensitive) {
        if (!this.foreignKeys.isEmpty()) {
            final Collator collator = Collator.getInstance();
            Collections.sort(this.foreignKeys, new Comparator<ForeignKey>(){

                @Override
                public int compare(ForeignKey obj1, ForeignKey obj2) {
                    String fk1Name = obj1.getName();
                    String fk2Name = obj2.getName();
                    if (!caseSensitive) {
                        fk1Name = fk1Name != null ? fk1Name.toLowerCase() : null;
                        fk2Name = fk2Name != null ? fk2Name.toLowerCase() : null;
                    }
                    return collator.compare(fk1Name, fk2Name);
                }
            });
        }
    }

    public Object clone() throws CloneNotSupportedException {
        Table result = (Table)super.clone();
        result.catalog = this.catalog;
        result.schema = this.schema;
        result.name = this.name;
        result.type = this.type;
        result.columns = (ArrayList)this.columns.clone();
        result.foreignKeys = (ArrayList)this.foreignKeys.clone();
        result.indices = (ArrayList)this.indices.clone();
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Table) {
            Table other = (Table)obj;
            return new EqualsBuilder().append((Object)this.name, (Object)other.name).append(this.columns, other.columns).append(new HashSet<ForeignKey>(this.foreignKeys), new HashSet<ForeignKey>(other.foreignKeys)).append(new HashSet<Index>(this.indices), new HashSet<Index>(other.indices)).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.name).append(this.columns).append(new HashSet<ForeignKey>(this.foreignKeys)).append(new HashSet<Index>(this.indices)).toHashCode();
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("Table [name=");
        result.append(this.getName());
        result.append("; ");
        result.append(this.getColumnCount());
        result.append(" columns]");
        return result.toString();
    }

    public String toVerboseString() {
        int idx;
        StringBuffer result = new StringBuffer();
        result.append("Table [name=");
        result.append(this.getName());
        result.append("; catalog=");
        result.append(this.getCatalog());
        result.append("; schema=");
        result.append(this.getSchema());
        result.append("; type=");
        result.append(this.getType());
        result.append("] columns:");
        for (idx = 0; idx < this.getColumnCount(); ++idx) {
            result.append(" ");
            result.append(this.getColumn(idx).toVerboseString());
        }
        result.append("; indices:");
        for (idx = 0; idx < this.getIndexCount(); ++idx) {
            result.append(" ");
            result.append(this.getIndex(idx).toVerboseString());
        }
        result.append("; foreign keys:");
        for (idx = 0; idx < this.getForeignKeyCount(); ++idx) {
            result.append(" ");
            result.append(this.getForeignKey(idx).toVerboseString());
        }
        return result.toString();
    }

    public String getFullyQualifiedTableName() {
        return Table.getFullyQualifiedTableName(this.name, this.schema, this.catalog);
    }

    public static String getFullyQualifiedTableName(String tableName, String schemaName, String catalogName) {
        return Table.getQualifiedTablePrefix(schemaName, catalogName) + tableName;
    }

    public static String getQualifiedTablePrefix(String schemaName, String catalogName) {
        String fullyQualified = "";
        if (!StringUtils.isBlank((String)schemaName)) {
            fullyQualified = schemaName + "." + fullyQualified;
        }
        if (!StringUtils.isBlank((String)catalogName)) {
            fullyQualified = catalogName + "." + fullyQualified;
        }
        return fullyQualified;
    }

    public Column getColumnWithName(String name) {
        Column[] columns = this.getColumns();
        if (columns != null) {
            for (Column column : columns) {
                if (!column.getName().equalsIgnoreCase(name)) continue;
                return column;
            }
        }
        return null;
    }

    public boolean doesIndexContainOnlyPrimaryKeyColumns(Index index) {
        IndexColumn[] columns = index.getColumns();
        if (columns != null) {
            for (IndexColumn indexColumn : columns) {
                Column column = this.getColumnWithName(indexColumn.getName());
                if (column != null && column.isPrimaryKey()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean hasAutoIncrementColumn() {
        if (this.columns != null) {
            for (Column column : this.getColumns()) {
                if (!column.isAutoIncrement()) continue;
                return true;
            }
        }
        return false;
    }

    public Column[] getDistributionKeyColumns() {
        if (this.columns != null) {
            ArrayList<Column> selectedColumns = new ArrayList<Column>();
            for (Column column : this.columns) {
                if (!column.isDistributionKey()) continue;
                selectedColumns.add(column);
            }
            return selectedColumns.toArray(new Column[selectedColumns.size()]);
        }
        return new Column[0];
    }
}

