/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.ddl.platform.derby;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import org.jumpmind.symmetric.ddl.Platform;
import org.jumpmind.symmetric.ddl.model.Column;
import org.jumpmind.symmetric.ddl.model.ForeignKey;
import org.jumpmind.symmetric.ddl.model.Index;
import org.jumpmind.symmetric.ddl.model.Table;
import org.jumpmind.symmetric.ddl.model.TypeMap;
import org.jumpmind.symmetric.ddl.platform.DatabaseMetaDataWrapper;
import org.jumpmind.symmetric.ddl.platform.JdbcModelReader;

public class DerbyModelReader
extends JdbcModelReader {
    public DerbyModelReader(Platform platform) {
        super(platform);
    }

    protected Column readColumn(DatabaseMetaDataWrapper metaData, Map values) throws SQLException {
        Column column = super.readColumn(metaData, values);
        String defaultValue = column.getDefaultValue();
        if (defaultValue != null) {
            if ("GENERATED_BY_DEFAULT".equals(defaultValue) || defaultValue.startsWith("AUTOINCREMENT:")) {
                column.setDefaultValue(null);
                column.setAutoIncrement(true);
            } else if (TypeMap.isTextType(column.getTypeCode())) {
                column.setDefaultValue(this.unescape(defaultValue, "'", "''"));
            }
        }
        return column;
    }

    protected boolean isInternalForeignKeyIndex(Connection connection, DatabaseMetaDataWrapper metaData, Table table, ForeignKey fk, Index index) {
        return this.isInternalIndex(index);
    }

    protected boolean isInternalPrimaryKeyIndex(Connection connection, DatabaseMetaDataWrapper metaData, Table table, Index index) {
        return this.isInternalIndex(index);
    }

    private boolean isInternalIndex(Index index) {
        String name = index.getName();
        if (name != null && name.startsWith("SQL")) {
            try {
                Long.parseLong(name.substring(3));
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }
}

