/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.ddl.platform.hsqldb2;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jumpmind.symmetric.ddl.Platform;
import org.jumpmind.symmetric.ddl.alteration.AddColumnChange;
import org.jumpmind.symmetric.ddl.alteration.ColumnDataTypeChange;
import org.jumpmind.symmetric.ddl.alteration.ColumnSizeChange;
import org.jumpmind.symmetric.ddl.alteration.RemoveColumnChange;
import org.jumpmind.symmetric.ddl.alteration.TableChange;
import org.jumpmind.symmetric.ddl.model.Column;
import org.jumpmind.symmetric.ddl.model.Database;
import org.jumpmind.symmetric.ddl.model.Index;
import org.jumpmind.symmetric.ddl.model.Table;
import org.jumpmind.symmetric.ddl.platform.SqlBuilder;

public class HsqlDb2Builder
extends SqlBuilder {
    public HsqlDb2Builder(Platform platform) {
        super(platform);
        this.addEscapedCharSequence("'", "''");
    }

    public void dropTable(Table table) throws IOException {
        this.print("DROP TABLE ");
        this.printIdentifier(this.getTableName(table));
        this.print(" IF EXISTS");
        this.printEndOfStatement();
    }

    public String getSelectLastIdentityValues(Table table) {
        return "CALL IDENTITY()";
    }

    protected boolean shouldGeneratePrimaryKeys(Column[] primaryKeyColumns) {
        if (primaryKeyColumns != null && primaryKeyColumns.length == 1) {
            return !primaryKeyColumns[0].isAutoIncrement();
        }
        return true;
    }

    protected void processTableStructureChanges(Database currentModel, Database desiredModel, Table sourceTable, Table targetTable, Map parameters, List changes) throws IOException {
        TableChange change;
        Iterator changeIt = changes.iterator();
        while (changeIt.hasNext()) {
            ColumnDataTypeChange dataTypeChange;
            ColumnSizeChange sizeChange;
            TableChange change2 = (TableChange)changeIt.next();
            if (change2 instanceof RemoveColumnChange && ((RemoveColumnChange)change2).getColumn().isPrimaryKey()) {
                changeIt.remove();
            }
            if (change2 instanceof ColumnSizeChange && (sizeChange = (ColumnSizeChange)change2).getChangedColumn().getTypeCode() == 12 && sizeChange.getNewSize() == 0) {
                changeIt.remove();
            }
            if (!(change2 instanceof ColumnDataTypeChange) || (dataTypeChange = (ColumnDataTypeChange)change2).getChangedColumn().getTypeCode() != 12 || dataTypeChange.getNewTypeCode() != -1) continue;
            changeIt.remove();
        }
        ArrayList<TableChange> addColumnChanges = new ArrayList<TableChange>();
        Iterator changeIt2 = changes.iterator();
        while (changeIt2.hasNext()) {
            change = (TableChange)changeIt2.next();
            if (!(change instanceof AddColumnChange)) continue;
            addColumnChanges.add(change);
            changeIt2.remove();
        }
        changeIt2 = addColumnChanges.listIterator(addColumnChanges.size());
        while (changeIt2.hasPrevious()) {
            AddColumnChange addColumnChange = (AddColumnChange)changeIt2.previous();
            this.processChange(currentModel, desiredModel, addColumnChange);
            changeIt2.remove();
        }
        changeIt2 = changes.iterator();
        while (changeIt2.hasNext()) {
            change = (TableChange)changeIt2.next();
            if (!(change instanceof RemoveColumnChange)) continue;
            RemoveColumnChange removeColumnChange = (RemoveColumnChange)change;
            this.processChange(currentModel, desiredModel, removeColumnChange);
            changeIt2.remove();
        }
    }

    protected void processChange(Database currentModel, Database desiredModel, AddColumnChange change) throws IOException {
        this.print("ALTER TABLE ");
        this.printlnIdentifier(this.getTableName(change.getChangedTable()));
        this.printIndent();
        this.print("ADD COLUMN ");
        this.writeColumn(change.getChangedTable(), change.getNewColumn());
        if (change.getNextColumn() != null) {
            this.print(" BEFORE ");
            this.printIdentifier(this.getColumnName(change.getNextColumn()));
        }
        this.printEndOfStatement();
        change.apply(currentModel, this.getPlatform().isDelimitedIdentifierModeOn());
    }

    protected void processChange(Database currentModel, Database desiredModel, RemoveColumnChange change) throws IOException {
        this.print("ALTER TABLE ");
        this.printlnIdentifier(this.getTableName(change.getChangedTable()));
        this.printIndent();
        this.print("DROP COLUMN ");
        this.printIdentifier(this.getColumnName(change.getColumn()));
        this.printEndOfStatement();
        change.apply(currentModel, this.getPlatform().isDelimitedIdentifierModeOn());
    }

    public void writeExternalIndexDropStmt(Table table, Index index) throws IOException {
        this.print("DROP INDEX ");
        this.printIdentifier(this.getIndexName(index));
        this.printEndOfStatement();
    }
}

