/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.ddl.platform.hsqldb2;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import org.jumpmind.symmetric.ddl.Platform;
import org.jumpmind.symmetric.ddl.model.Column;
import org.jumpmind.symmetric.ddl.model.ForeignKey;
import org.jumpmind.symmetric.ddl.model.Index;
import org.jumpmind.symmetric.ddl.model.Table;
import org.jumpmind.symmetric.ddl.model.TypeMap;
import org.jumpmind.symmetric.ddl.platform.DatabaseMetaDataWrapper;
import org.jumpmind.symmetric.ddl.platform.JdbcModelReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HsqlDb2ModelReader
extends JdbcModelReader {
    public HsqlDb2ModelReader(Platform platform) {
        super(platform);
        this.setDefaultCatalogPattern(null);
        this.setDefaultSchemaPattern(null);
    }

    @Override
    protected Column readColumn(DatabaseMetaDataWrapper metaData, Map<String, Object> values) throws SQLException {
        String autoIncrement;
        Column column = super.readColumn(metaData, values);
        if (TypeMap.isTextType(column.getTypeCode()) && column.getDefaultValue() != null) {
            column.setDefaultValue(this.unescape(column.getDefaultValue(), "'", "''"));
        }
        if ((autoIncrement = (String)values.get("IS_AUTOINCREMENT")) != null) {
            column.setAutoIncrement("YES".equalsIgnoreCase(autoIncrement.trim()));
        }
        return column;
    }

    @Override
    protected boolean isInternalForeignKeyIndex(Connection connection, DatabaseMetaDataWrapper metaData, Table table, ForeignKey fk, Index index) {
        String name = index.getName();
        return name != null && name.startsWith("SYS_IDX_");
    }

    @Override
    protected boolean isInternalPrimaryKeyIndex(Connection connection, DatabaseMetaDataWrapper metaData, Table table, Index index) {
        String name = index.getName();
        return name != null && (name.startsWith("SYS_PK_") || name.startsWith("SYS_IDX_"));
    }
}

