/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.ddl.platform.informix;

import java.io.IOException;
import org.jumpmind.symmetric.ddl.Platform;
import org.jumpmind.symmetric.ddl.alteration.PrimaryKeyChange;
import org.jumpmind.symmetric.ddl.alteration.RemovePrimaryKeyChange;
import org.jumpmind.symmetric.ddl.model.Column;
import org.jumpmind.symmetric.ddl.model.Database;
import org.jumpmind.symmetric.ddl.model.ForeignKey;
import org.jumpmind.symmetric.ddl.model.Table;
import org.jumpmind.symmetric.ddl.platform.SqlBuilder;

public class InformixBuilder
extends SqlBuilder {
    public InformixBuilder(Platform platform) {
        super(platform);
    }

    protected void writeColumn(Table table, Column column) throws IOException {
        if (column.isAutoIncrement()) {
            this.printIdentifier(this.getColumnName(column));
            this.print(" SERIAL");
        } else {
            super.writeColumn(table, column);
        }
    }

    public String getSelectLastIdentityValues(Table table) {
        return "select dbinfo('sqlca.sqlerrd1') from sysmaster:sysdual";
    }

    protected void writeExternalPrimaryKeysCreateStmt(Table table, Column[] primaryKeyColumns) throws IOException {
        if (primaryKeyColumns.length > 0 && this.shouldGeneratePrimaryKeys(primaryKeyColumns)) {
            this.print("ALTER TABLE ");
            this.printlnIdentifier(this.getTableName(table));
            this.printIndent();
            this.print("ADD CONSTRAINT ");
            this.writePrimaryKeyStmt(table, primaryKeyColumns);
            this.print(" CONSTRAINT ");
            this.printIdentifier(this.getConstraintName(null, table, "PK", null));
            this.printEndOfStatement();
        }
    }

    protected void writeExternalForeignKeyCreateStmt(Database database, Table table, ForeignKey key) throws IOException {
        if (key.getForeignTableName() == null) {
            this._log.warn((Object)("Foreign key table is null for key " + key));
        } else {
            this.writeTableAlterStmt(table);
            this.print("ADD CONSTRAINT FOREIGN KEY (");
            this.writeLocalReferences(key);
            this.print(") REFERENCES ");
            this.printIdentifier(this.getTableName(database.findTable(key.getForeignTableName())));
            this.print(" (");
            this.writeForeignReferences(key);
            this.print(") CONSTRAINT ");
            this.printIdentifier(this.getForeignKeyName(table, key));
            this.printEndOfStatement();
        }
    }

    protected void processChange(Database currentModel, Database desiredModel, RemovePrimaryKeyChange change) throws IOException {
        this.print("ALTER TABLE ");
        this.printlnIdentifier(this.getTableName(change.getChangedTable()));
        this.printIndent();
        this.print("DROP CONSTRAINT ");
        this.printIdentifier(this.getConstraintName(null, change.getChangedTable(), "PK", null));
        this.printEndOfStatement();
        change.apply(currentModel, this.getPlatform().isDelimitedIdentifierModeOn());
    }

    protected void processChange(Database currentModel, Database desiredModel, PrimaryKeyChange change) throws IOException {
        this.print("ALTER TABLE ");
        this.printlnIdentifier(this.getTableName(change.getChangedTable()));
        this.printIndent();
        this.print("DROP CONSTRAINT ");
        this.printIdentifier(this.getConstraintName(null, change.getChangedTable(), "PK", null));
        this.printEndOfStatement();
        this.writeExternalPrimaryKeysCreateStmt(change.getChangedTable(), change.getNewPrimaryKeyColumns());
        change.apply(currentModel, this.getPlatform().isDelimitedIdentifierModeOn());
    }
}

