/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.ddl.platform.postgresql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import org.jumpmind.symmetric.ddl.DatabaseOperationException;
import org.jumpmind.symmetric.ddl.PlatformInfo;
import org.jumpmind.symmetric.ddl.platform.PlatformImplBase;
import org.jumpmind.symmetric.ddl.platform.postgresql.PostgreSqlBuilder;
import org.jumpmind.symmetric.ddl.platform.postgresql.PostgreSqlModelReader;

public class PostgreSqlPlatform
extends PlatformImplBase {
    public static final String DATABASENAME = "PostgreSql";
    public static final String JDBC_DRIVER = "org.postgresql.Driver";
    public static final String JDBC_SUBPROTOCOL = "postgresql";

    public PostgreSqlPlatform() {
        PlatformInfo info = this.getPlatformInfo();
        info.setMaxIdentifierLength(31);
        info.addNativeTypeMapping(2003, "BYTEA", -4);
        info.addNativeTypeMapping(-2, "BYTEA", -4);
        info.addNativeTypeMapping(-7, "BOOLEAN");
        info.addNativeTypeMapping(2004, "BYTEA", -4);
        info.addNativeTypeMapping(2005, "TEXT", -1);
        info.addNativeTypeMapping(3, "NUMERIC", 2);
        info.addNativeTypeMapping(2001, "BYTEA", -4);
        info.addNativeTypeMapping(8, "DOUBLE PRECISION");
        info.addNativeTypeMapping(6, "DOUBLE PRECISION", 8);
        info.addNativeTypeMapping(2000, "BYTEA", -4);
        info.addNativeTypeMapping(-4, "BYTEA");
        info.addNativeTypeMapping(-1, "TEXT", -1);
        info.addNativeTypeMapping(0, "BYTEA", -4);
        info.addNativeTypeMapping(1111, "BYTEA", -4);
        info.addNativeTypeMapping(2006, "BYTEA", -4);
        info.addNativeTypeMapping(2002, "BYTEA", -4);
        info.addNativeTypeMapping(-6, "SMALLINT", 5);
        info.addNativeTypeMapping(-3, "BYTEA", -4);
        info.addNativeTypeMapping("BOOLEAN", "BOOLEAN", "BIT");
        info.addNativeTypeMapping("DATALINK", "BYTEA", "LONGVARBINARY");
        info.setDefaultSize(1, 254);
        info.setDefaultSize(12, 254);
        info.setHasSize(-2, false);
        info.setHasSize(-3, false);
        this.setDelimitedIdentifierModeOn(true);
        this.setSqlBuilder(new PostgreSqlBuilder(this));
        this.setModelReader(new PostgreSqlModelReader(this));
    }

    public String getName() {
        return DATABASENAME;
    }

    private void createOrDropDatabase(String jdbcDriverClassName, String connectionUrl, String username, String password, Map parameters, boolean createDb) throws DatabaseOperationException, UnsupportedOperationException {
        if (JDBC_DRIVER.equals(jdbcDriverClassName)) {
            int slashPos = connectionUrl.lastIndexOf(47);
            if (slashPos < 0) {
                throw new DatabaseOperationException("Cannot parse the given connection url " + connectionUrl);
            }
            int paramPos = connectionUrl.lastIndexOf(63);
            String baseDb = connectionUrl.substring(0, slashPos + 1) + "template1";
            String dbName = paramPos > slashPos ? connectionUrl.substring(slashPos + 1, paramPos) : connectionUrl.substring(slashPos + 1);
            Connection connection = null;
            Statement stmt = null;
            StringBuffer sql = new StringBuffer();
            sql.append(createDb ? "CREATE" : "DROP");
            sql.append(" DATABASE ");
            sql.append(dbName);
            if (parameters != null && !parameters.isEmpty()) {
                for (Map.Entry entry : parameters.entrySet()) {
                    sql.append(" ");
                    sql.append(entry.getKey().toString());
                    if (entry.getValue() == null) continue;
                    sql.append(" ");
                    sql.append(entry.getValue().toString());
                }
            }
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((Object)("About to create database via " + baseDb + " using this SQL: " + sql.toString()));
            }
            try {
                Class.forName(jdbcDriverClassName);
                connection = DriverManager.getConnection(baseDb, username, password);
                stmt = connection.createStatement();
                stmt.execute(sql.toString());
                this.logWarnings(connection);
            }
            catch (Exception ex) {
                throw new DatabaseOperationException("Error while trying to " + (createDb ? "create" : "drop") + " a database: " + ex.getLocalizedMessage(), ex);
            }
            finally {
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException ex) {}
                }
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException ex) {}
                }
            }
        }
        throw new UnsupportedOperationException("Unable to " + (createDb ? "create" : "drop") + " a PostgreSQL database via the driver " + jdbcDriverClassName);
    }

    public void createDatabase(String jdbcDriverClassName, String connectionUrl, String username, String password, Map parameters) throws DatabaseOperationException, UnsupportedOperationException {
        this.createOrDropDatabase(jdbcDriverClassName, connectionUrl, username, password, parameters, true);
    }

    public void dropDatabase(String jdbcDriverClassName, String connectionUrl, String username, String password) throws DatabaseOperationException, UnsupportedOperationException {
        this.createOrDropDatabase(jdbcDriverClassName, connectionUrl, username, password, null, false);
    }
}

