/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.servlet.ServletContext;
import mx4j.tools.adaptor.http.HttpAdaptor;
import mx4j.tools.adaptor.http.XSLTProcessor;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jetty.http.security.Constraint;
import org.eclipse.jetty.http.security.Credential;
import org.eclipse.jetty.http.security.Password;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.bio.SocketConnector;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.server.ssl.SslSocketConnector;
import org.eclipse.jetty.webapp.WebAppContext;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.SymmetricEngineHolder;
import org.jumpmind.symmetric.common.logging.ILog;
import org.jumpmind.symmetric.common.logging.LogFactory;
import org.jumpmind.symmetric.util.AppUtils;
import org.jumpmind.symmetric.web.ServletUtils;

public class SymmetricWebServer {
    protected static final ILog log = LogFactory.getLog(SymmetricWebServer.class);
    protected static final String DEFAULT_WEBAPP_DIR = System.getProperty("symmetric.default.web.dir", "../web");
    public static final String DEFAULT_HTTP_PORT = System.getProperty("symmetric.default.http.port", "31415");
    public static final String DEFAULT_HTTPS_PORT = System.getProperty("symmetric.default.https.port", "31417");
    private Server server;
    private WebAppContext webapp;
    protected boolean join = true;
    protected boolean createJmxServer = Boolean.parseBoolean(System.getProperty("symmetric.default.create.jmx.server", "true"));
    protected String webHome = "/";
    protected int maxIdleTime = 0x6DDD00;
    protected int httpPort = -1;
    protected int httpsPort = -1;
    protected String basicAuthUsername = null;
    protected String basicAuthPassword = null;
    protected String propertiesFile = null;
    protected String host = null;
    protected boolean noNio = false;
    protected boolean noDirectBuffer = false;
    protected String webAppDir = DEFAULT_WEBAPP_DIR;
    protected String name = "SymmetricDS";

    public SymmetricWebServer() {
    }

    public SymmetricWebServer(String propertiesUrl) {
        this(propertiesUrl, DEFAULT_WEBAPP_DIR);
    }

    public SymmetricWebServer(String propertiesUrl, String webappDir) {
        this.propertiesFile = propertiesUrl;
        this.webAppDir = webappDir;
    }

    public SymmetricWebServer(String webDirectory, int maxIdleTime, String propertiesUrl, boolean join, boolean noNio, boolean noDirectBuffer) {
        this(propertiesUrl, webDirectory);
        this.maxIdleTime = maxIdleTime;
        this.join = join;
        this.noDirectBuffer = noDirectBuffer;
        this.noNio = noNio;
    }

    public SymmetricWebServer(int maxIdleTime, String propertiesUrl) {
        this(propertiesUrl, DEFAULT_WEBAPP_DIR);
        this.maxIdleTime = maxIdleTime;
    }

    public SymmetricWebServer start(int port, String propertiesUrl) throws Exception {
        this.propertiesFile = propertiesUrl;
        return this.start(port);
    }

    public SymmetricWebServer start() throws Exception {
        if (this.httpPort > 0 && this.httpsPort > 0) {
            return this.startMixed(this.httpPort, this.httpsPort);
        }
        if (this.httpPort > 0) {
            return this.start(this.httpPort);
        }
        if (this.httpsPort > 0) {
            return this.startSecure(this.httpsPort);
        }
        throw new IllegalStateException("Either an http or https port needs to be set before starting the server.");
    }

    public SymmetricWebServer start(int port) throws Exception {
        return this.start(port, 0, Mode.HTTP);
    }

    public SymmetricWebServer startSecure(int port) throws Exception {
        return this.start(0, port, Mode.HTTPS);
    }

    public SymmetricWebServer startMixed(int port, int securePort) throws Exception {
        return this.start(port, securePort, Mode.MIXED);
    }

    public SymmetricWebServer start(int port, int securePort, Mode mode) throws Exception {
        System.setProperty("symmetric.standalone.web", "true");
        this.server = new Server();
        this.server.setConnectors(this.getConnectors(port, securePort, mode));
        this.setupBasicAuthIfNeeded(this.server);
        this.webapp = new WebAppContext();
        this.webapp.setParentLoaderPriority(true);
        this.webapp.setContextPath(this.webHome);
        this.webapp.setWar(this.webAppDir);
        this.webapp.getSessionHandler().getSessionManager().setMaxInactiveInterval(this.maxIdleTime / 1000);
        this.server.setHandler((Handler)this.webapp);
        if (!StringUtils.isBlank((String)this.propertiesFile)) {
            System.setProperty("symmetric.override.properties.file.1", this.propertiesFile);
        }
        this.server.start();
        if (this.createJmxServer) {
            int httpJmxPort = port != 0 ? port + 1 : securePort + 1;
            this.registerHttpJmxAdaptor(httpJmxPort);
        }
        if (this.join) {
            log.info("WebServerAboutToJoin");
            this.server.join();
        }
        return this;
    }

    protected ServletContext getServletContext() {
        return this.webapp != null ? this.webapp.getServletContext() : null;
    }

    public ISymmetricEngine getEngine() {
        SymmetricEngineHolder engineHolder;
        ISymmetricEngine engine = null;
        ServletContext servletContext = this.getServletContext();
        if (servletContext != null && (engineHolder = ServletUtils.getSymmetricEngineHolder(servletContext)) != null) {
            if (engineHolder.getEngines().size() == 1) {
                return (ISymmetricEngine)engineHolder.getEngines().values().iterator().next();
            }
            throw new IllegalStateException("There are more than " + engineHolder.getEngines().size() + " engines configured.");
        }
        return engine;
    }

    protected void setupBasicAuthIfNeeded(Server server) {
        if (StringUtils.isNotBlank((String)this.basicAuthUsername)) {
            ConstraintSecurityHandler sh = new ConstraintSecurityHandler();
            Constraint constraint = new Constraint();
            constraint.setName("BASIC");
            constraint.setRoles(new String[]{"symmetric"});
            constraint.setAuthenticate(true);
            ConstraintMapping cm = new ConstraintMapping();
            cm.setConstraint(constraint);
            cm.setPathSpec("/*");
            sh.addConstraintMapping(cm);
            sh.setAuthenticator((Authenticator)new BasicAuthenticator());
            HashLoginService loginService = new HashLoginService();
            loginService.putUser(this.basicAuthUsername, (Credential)new Password(this.basicAuthPassword), null);
            sh.setLoginService((LoginService)loginService);
            server.setHandler((Handler)sh);
        }
    }

    protected Connector[] getConnectors(int port, int securePort, Mode mode) {
        SocketConnector connector;
        ArrayList<SocketConnector> connectors = new ArrayList<SocketConnector>();
        String keyStoreFile = System.getProperty("sym.keystore.file");
        String keyStoreType = System.getProperty("sym.keystore.type");
        if (mode.equals((Object)Mode.HTTP) || mode.equals((Object)Mode.MIXED)) {
            connector = null;
            if (this.noNio) {
                connector = new SocketConnector();
            } else {
                SelectChannelConnector nioConnector = new SelectChannelConnector();
                nioConnector.setUseDirectBuffers(!this.noDirectBuffer);
                connector = nioConnector;
            }
            connector.setPort(port);
            connector.setHost(this.host);
            connector.setMaxIdleTime(this.maxIdleTime);
            connectors.add(connector);
            log.info("WebServerStarting", new Object[]{this.name, port});
        }
        if (mode.equals((Object)Mode.HTTPS) || mode.equals((Object)Mode.MIXED)) {
            connector = new SslSocketConnector();
            String keyStorePassword = System.getProperty("javax.net.ssl.keyStorePassword");
            keyStorePassword = keyStorePassword != null ? keyStorePassword : "changeit";
            ((SslSocketConnector)connector).setKeystore(keyStoreFile);
            ((SslSocketConnector)connector).setKeyPassword(keyStorePassword);
            if (keyStoreType != null) {
                ((SslSocketConnector)connector).setKeystoreType(keyStoreType);
            }
            ((SslSocketConnector)connector).setMaxIdleTime(this.maxIdleTime);
            connector.setPort(securePort);
            connector.setHost(this.host);
            connectors.add(connector);
            log.info("WebServerSecureStarting", new Object[]{securePort});
        }
        return connectors.toArray(new Connector[connectors.size()]);
    }

    protected void registerHttpJmxAdaptor(int jmxPort) throws Exception {
        if (AppUtils.isSystemPropertySet((String)"jmx.http.console.for.embedded.webserver.enabled", (boolean)true)) {
            log.info("JMXConsoleStarting", new Object[]{jmxPort});
            MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
            ObjectName name = this.getHttpJmxAdaptorName();
            mbeanServer.createMBean(HttpAdaptor.class.getName(), name);
            if (!AppUtils.isSystemPropertySet((String)"jmx.http.console.localhost.only.enabled", (boolean)true)) {
                mbeanServer.setAttribute(name, new Attribute("Host", "0.0.0.0"));
            }
            mbeanServer.setAttribute(name, new Attribute("Port", new Integer(jmxPort)));
            ObjectName processorName = this.getXslJmxAdaptorName();
            mbeanServer.createMBean(XSLTProcessor.class.getName(), processorName);
            mbeanServer.setAttribute(name, new Attribute("ProcessorName", processorName));
            mbeanServer.invoke(name, "start", null, null);
        }
    }

    protected ObjectName getHttpJmxAdaptorName() throws MalformedObjectNameException {
        return new ObjectName("Server:name=HttpAdaptor");
    }

    protected ObjectName getXslJmxAdaptorName() throws MalformedObjectNameException {
        return new ObjectName("Server:name=XSLTProcessor");
    }

    protected void removeHttpJmxAdaptor() {
        if (AppUtils.isSystemPropertySet((String)"jmx.http.console.for.embedded.webserver.enabled", (boolean)true)) {
            try {
                MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
                mbeanServer.unregisterMBean(this.getHttpJmxAdaptorName());
                mbeanServer.unregisterMBean(this.getXslJmxAdaptorName());
            }
            catch (Exception e) {
                log.warn("JMXAdaptorUnregisterFailed");
            }
        }
    }

    public void stop() throws Exception {
        if (this.server != null) {
            if (this.createJmxServer) {
                this.removeHttpJmxAdaptor();
            }
            this.server.stop();
        }
    }

    public static void main(String[] args) throws Exception {
        new SymmetricWebServer().start(8080);
    }

    public boolean isJoin() {
        return this.join;
    }

    public void setJoin(boolean join) {
        this.join = join;
    }

    public void setWebHome(String webHome) {
        this.webHome = webHome;
    }

    public int getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public void setMaxIdleTime(int maxIdleTime) {
        this.maxIdleTime = maxIdleTime;
    }

    public void setHttpPort(int httpPort) {
        this.httpPort = httpPort;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public void setHttpsPort(int httpsPort) {
        this.httpsPort = httpsPort;
    }

    public int getHttpsPort() {
        return this.httpsPort;
    }

    public void setPropertiesFile(String propertiesFile) {
        this.propertiesFile = propertiesFile;
    }

    public void setCreateJmxServer(boolean createJmxServer) {
        this.createJmxServer = createJmxServer;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setBasicAuthPassword(String basicAuthPassword) {
        this.basicAuthPassword = basicAuthPassword;
    }

    public void setBasicAuthUsername(String basicAuthUsername) {
        this.basicAuthUsername = basicAuthUsername;
    }

    public void setWebAppDir(String webAppDir) {
        this.webAppDir = webAppDir;
    }

    public void setNoNio(boolean noNio) {
        this.noNio = noNio;
    }

    public void setNoDirectBuffer(boolean noDirectBuffer) {
        this.noDirectBuffer = noDirectBuffer;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        HTTP,
        HTTPS,
        MIXED;

    }
}

